export default function About4({ data }) {
    const { image_url, section_title, section_subtitle, section_description, feature_list } = data
    return (
        <div className="container">
            <div className="row align-items-center cs_gap_y_40">
                <div className="col-lg-6">
                    <div className="cs_image_card cs_style_2">
                        <div className="cs_image_card_in">{image_url && <img src={image_url} alt={section_title} className="w-100" />}</div>
                        <svg
                            className="cs_shape_1 cs_accent_color"
                            width={148}
                            height={145}
                            viewBox="0 0 148 145"
                            fill="none"
                            xmlns="http://www.w3.org/2000/svg"
                        >
                            <mask id="mask0_10" style={{ maskType: "luminance" }} maskUnits="userSpaceOnUse" x={0} y={0} width={148} height={145}>
                                <path d="M0.609375 51.478L99.2245 0.776666L147.089 93.8749L48.4743 144.576L0.609375 51.478Z" fill="white" />
                            </mask>
                            <g mask="url(#mask0_10)">
                                <path
                                    d="M51.6057 140.309C51.82 140.725 51.9057 141.196 51.8522 141.661C51.7986 142.126 51.6081 142.564 51.3048 142.921C51.0015 143.279 50.5991 143.538 50.1484 143.667C49.6978 143.795 49.2193 143.787 48.7736 143.644C48.1761 143.453 47.6795 143.033 47.3928 142.476C47.1043 141.916 47.049 141.265 47.2391 140.664C47.4291 140.063 47.849 139.561 48.4074 139.268C48.9711 138.986 49.6228 138.938 50.2214 139.133C50.82 139.328 51.3173 139.75 51.6057 140.309ZM65.0908 133.376C65.2996 133.793 65.38 134.263 65.322 134.726C65.2639 135.189 65.07 135.624 64.7646 135.977C64.459 136.331 64.0559 136.586 63.6059 136.712C63.1559 136.837 62.679 136.828 62.2349 136.684C61.7907 136.54 61.3994 136.267 61.1103 135.901C60.8213 135.534 60.6474 135.091 60.6108 134.625C60.5742 134.16 60.6763 133.694 60.9044 133.287C61.1325 132.879 61.4763 132.548 61.8924 132.335C62.1711 132.192 62.4752 132.105 62.7874 132.08C63.0996 132.054 63.4136 132.091 63.7113 132.188C64.0087 132.285 64.2837 132.44 64.5205 132.644C64.7573 132.848 64.9512 133.097 65.0908 133.376ZM78.5766 126.443C78.7854 126.86 78.8658 127.329 78.8078 127.792C78.7497 128.255 78.5558 128.691 78.2504 129.044C77.9448 129.397 77.5417 129.653 77.0917 129.778C76.6417 129.904 76.1648 129.894 75.7207 129.75C75.1999 129.582 74.7541 129.238 74.4592 128.777C74.1644 128.316 74.0388 127.768 74.1039 127.224C74.169 126.681 74.4208 126.177 74.8163 125.798C75.2118 125.419 75.7264 125.188 76.2725 125.146C76.5846 125.121 76.8983 125.159 77.1958 125.256C77.4932 125.353 77.7685 125.507 78.0059 125.711C78.2428 125.914 78.4364 126.163 78.5766 126.443ZM92.0654 119.508C92.2217 119.82 92.3068 120.162 92.3147 120.511C92.3226 120.86 92.253 121.207 92.111 121.526C91.969 121.845 91.758 122.128 91.4933 122.356C91.2285 122.584 90.9166 122.751 90.5799 122.845C90.13 122.969 89.6534 122.959 89.2098 122.814C88.7663 122.67 88.3754 122.398 88.0861 122.032C87.8701 121.758 87.7176 121.44 87.6395 121.1C87.5613 120.761 87.5594 120.408 87.634 120.067C87.7086 119.726 87.8578 119.406 88.0709 119.129C88.2839 118.852 88.5556 118.626 88.8663 118.467C89.145 118.323 89.4492 118.237 89.7613 118.211C90.0735 118.186 90.3875 118.223 90.6852 118.32C90.9827 118.416 91.2578 118.571 91.4948 118.775C91.7317 118.979 91.9257 119.228 92.0654 119.508ZM105.55 112.575C105.759 112.992 105.84 113.461 105.782 113.924C105.723 114.387 105.53 114.822 105.224 115.176C104.919 115.529 104.516 115.784 104.066 115.91C103.616 116.036 103.139 116.026 102.695 115.882C102.25 115.738 101.859 115.465 101.57 115.099C101.281 114.733 101.107 114.289 101.071 113.824C101.034 113.358 101.136 112.893 101.364 112.485C101.592 112.077 101.936 111.746 102.352 111.533C102.631 111.39 102.935 111.303 103.247 111.278C103.559 111.253 103.873 111.29 104.17 111.387C104.468 111.483 104.743 111.638 104.98 111.842C105.217 112.046 105.411 112.295 105.55 112.575ZM119.036 105.641C119.245 106.058 119.325 106.528 119.267 106.991C119.209 107.454 119.015 107.889 118.709 108.243C118.404 108.596 118.001 108.851 117.551 108.976C117.101 109.102 116.624 109.092 116.18 108.948C115.736 108.804 115.345 108.532 115.056 108.166C114.767 107.8 114.593 107.356 114.556 106.891C114.52 106.425 114.622 105.96 114.85 105.552C115.078 105.144 115.421 104.813 115.837 104.6C116.116 104.457 116.42 104.37 116.732 104.345C117.044 104.32 117.358 104.356 117.656 104.453C117.954 104.55 118.229 104.705 118.466 104.909C118.703 105.113 118.897 105.362 119.036 105.641ZM132.522 98.7077C132.704 99.072 132.789 99.4773 132.768 99.8843C132.748 100.291 132.622 100.686 132.404 101.031C132.185 101.375 131.881 101.658 131.522 101.85C131.162 102.043 130.759 102.14 130.351 102.132C129.943 102.123 129.545 102.009 129.194 101.801C128.843 101.594 128.553 101.299 128.35 100.945C128.147 100.592 128.039 100.192 128.037 99.7846C128.035 99.3771 128.138 98.9758 128.336 98.6195C128.604 98.1403 129.031 97.7686 129.542 97.5681C130.054 97.3675 130.619 97.3505 131.141 97.5199C131.439 97.6169 131.714 97.7718 131.951 97.9757C132.188 98.1795 132.382 98.4283 132.522 98.7077ZM146.007 91.7745C146.164 92.0863 146.249 92.429 146.257 92.7778C146.265 93.1266 146.195 93.473 146.053 93.792C145.911 94.111 145.7 94.3948 145.436 94.6228C145.171 94.8509 144.859 95.0176 144.522 95.1111C144.072 95.2364 143.596 95.2262 143.152 95.0817C142.708 94.9373 142.317 94.6649 142.028 94.299C141.739 93.933 141.565 93.4894 141.528 93.0243C141.491 92.5591 141.594 92.0934 141.822 91.686C141.993 91.3794 142.231 91.1147 142.517 90.911C142.804 90.7073 143.132 90.5696 143.478 90.508C143.824 90.4464 144.179 90.4624 144.518 90.5548C144.856 90.6472 145.17 90.8138 145.436 91.0424C145.673 91.2457 145.867 91.4944 146.007 91.7745ZM45.0765 127.61C45.2184 127.886 45.3044 128.187 45.3296 128.497C45.3549 128.806 45.3188 129.118 45.2236 129.414C45.1283 129.709 44.9757 129.984 44.7745 130.221C44.5732 130.458 44.3273 130.653 44.0507 130.795C43.7741 130.937 43.4722 131.023 43.1624 131.049C42.8526 131.075 42.5408 131.039 42.2449 130.945C41.9489 130.85 41.6747 130.698 41.4377 130.497C41.2008 130.296 41.0058 130.051 40.8639 129.775C40.5773 129.217 40.5244 128.568 40.7168 127.971C40.9092 127.374 41.3311 126.877 41.8897 126.59C42.4483 126.303 43.0979 126.249 43.6955 126.44C44.2932 126.632 44.7899 127.052 45.0765 127.61ZM58.5623 120.676C58.7041 120.953 58.7901 121.254 58.8153 121.564C58.8405 121.873 58.8044 122.185 58.7091 122.481C58.6138 122.776 58.4611 123.051 58.2598 123.288C58.0584 123.525 57.8124 123.72 57.5357 123.862C57.2591 124.004 56.9572 124.09 56.6472 124.116C56.3373 124.142 56.0255 124.106 55.7295 124.011C55.4336 123.916 55.1593 123.764 54.9224 123.563C54.6854 123.363 54.4904 123.117 54.3486 122.841C54.2067 122.565 54.1207 122.263 54.0956 121.954C54.0704 121.644 54.1065 121.333 54.2018 121.037C54.2971 120.741 54.4497 120.467 54.651 120.23C54.8523 119.993 55.0983 119.798 55.3749 119.656C55.6515 119.514 55.9534 119.428 56.2633 119.402C56.5731 119.377 56.8849 119.412 57.1808 119.507C57.4767 119.602 57.7509 119.754 57.9878 119.955C58.2247 120.155 58.4197 120.401 58.5615 120.677L58.5623 120.676ZM72.0473 113.743C72.1963 114.02 72.2884 114.324 72.3185 114.637C72.3485 114.949 72.3158 115.265 72.2222 115.565C72.1287 115.866 71.9761 116.144 71.7736 116.385C71.571 116.626 71.3225 116.824 71.0425 116.968C70.7625 117.112 70.4567 117.199 70.143 117.223C69.8292 117.248 69.5138 117.209 69.2152 117.111C68.9166 117.012 68.6408 116.855 68.4039 116.648C68.167 116.442 67.9738 116.19 67.8355 115.908C67.549 115.35 67.496 114.701 67.6884 114.104C67.8808 113.507 68.3027 113.01 68.8613 112.723C69.4199 112.436 70.0695 112.382 70.6671 112.573C71.2648 112.765 71.7608 113.186 72.0473 113.743ZM85.5362 106.808C85.6781 107.084 85.7641 107.386 85.7894 107.695C85.8146 108.005 85.7786 108.316 85.6833 108.612C85.5881 108.908 85.4355 109.182 85.2342 109.419C85.033 109.656 84.787 109.851 84.5104 109.993C84.2338 110.135 83.932 110.222 83.6221 110.247C83.3123 110.273 83.0005 110.238 82.7046 110.143C82.4087 110.048 82.1344 109.896 81.8975 109.695C81.6605 109.495 81.4655 109.249 81.3236 108.973C81.0371 108.415 80.9842 107.767 81.1765 107.169C81.3689 106.572 81.7908 106.075 82.3494 105.788C82.908 105.501 83.5576 105.447 84.1553 105.639C84.7529 105.83 85.2496 106.251 85.5362 106.808ZM99.0213 99.8752C99.1702 100.152 99.2624 100.455 99.2924 100.768C99.3224 101.081 99.2897 101.397 99.1961 101.697C99.1026 101.998 98.9501 102.276 98.7475 102.517C98.5449 102.758 98.2964 102.956 98.0164 103.1C97.7365 103.244 97.4307 103.331 97.1169 103.355C96.8032 103.38 96.4878 103.341 96.1892 103.243C95.8906 103.144 95.6148 102.987 95.3779 102.78C95.1409 102.574 94.9477 102.322 94.8095 102.04C94.6676 101.764 94.5815 101.462 94.5563 101.153C94.531 100.843 94.5671 100.532 94.6623 100.236C94.7576 99.9401 94.9102 99.6659 95.1114 99.4289C95.3127 99.1919 95.5586 98.9968 95.8352 98.8547C96.1118 98.7125 96.4137 98.6261 96.7235 98.6005C97.0334 98.5748 97.3451 98.6104 97.6411 98.7051C97.937 98.7998 98.2112 98.9519 98.4482 99.1526C98.6851 99.3532 98.8794 99.5991 99.0213 99.8752ZM112.507 92.9416C112.656 93.2183 112.748 93.522 112.778 93.8348C112.808 94.1477 112.776 94.4635 112.682 94.7638C112.588 95.064 112.436 95.3427 112.233 95.5836C112.031 95.8244 111.782 96.0226 111.502 96.1665C111.222 96.3103 110.916 96.3971 110.603 96.4216C110.289 96.446 109.974 96.4078 109.675 96.3091C109.376 96.2103 109.101 96.0531 108.864 95.8465C108.627 95.64 108.434 95.3883 108.295 95.1061C108.009 94.5485 107.956 93.8997 108.148 93.3024C108.341 92.7051 108.762 92.2082 109.321 91.9211C109.88 91.6341 110.529 91.5803 111.127 91.7716C111.725 91.9629 112.22 92.384 112.507 92.9416ZM125.993 86.0081C126.153 86.319 126.242 86.6615 126.253 87.011C126.264 87.3605 126.198 87.7083 126.058 88.0292C125.919 88.3502 125.71 88.6363 125.447 88.8671C125.183 89.0978 124.872 89.2674 124.535 89.3635C124.085 89.492 123.607 89.4845 123.161 89.3421C122.716 89.1996 122.323 88.9286 122.031 88.5631C121.813 88.2897 121.659 87.9713 121.579 87.6309C121.5 87.2904 121.497 86.9365 121.571 86.5946C121.645 86.2527 121.795 85.9315 122.008 85.6541C122.222 85.3767 122.494 85.15 122.806 84.9905C123.364 84.7034 124.014 84.6494 124.611 84.8402C125.209 85.031 125.706 85.4511 125.993 86.0081ZM139.478 79.075C139.638 79.3859 139.727 79.7284 139.738 80.0779C139.75 80.4275 139.683 80.7753 139.544 81.0963C139.404 81.4173 139.195 81.7035 138.932 81.9342C138.668 82.1649 138.357 82.3344 138.02 82.4304C137.57 82.5587 137.092 82.5512 136.646 82.4088C136.201 82.2663 135.808 81.9954 135.516 81.63C135.225 81.2641 135.049 80.82 135.012 80.3539C134.974 79.8879 135.075 79.4209 135.303 79.0121C135.511 78.637 135.817 78.3253 136.188 78.1103C136.56 77.8954 136.982 77.7852 137.411 77.7917C137.84 77.7982 138.259 77.921 138.623 78.147C138.987 78.3731 139.283 78.6939 139.478 79.075ZM38.5472 114.91C38.7073 115.221 38.7962 115.564 38.8075 115.913C38.8189 116.263 38.7524 116.611 38.6129 116.932C38.4734 117.253 38.2644 117.539 38.0009 117.769C37.7374 118 37.426 118.169 37.0892 118.265C36.7528 118.361 36.3995 118.382 36.0546 118.325C35.7096 118.268 35.3816 118.136 35.0941 117.938C34.8065 117.739 34.5666 117.48 34.3916 117.178C34.2166 116.876 34.1107 116.538 34.0817 116.19C34.0563 115.881 34.0922 115.569 34.1873 115.273C34.2825 114.978 34.4352 114.703 34.6365 114.466C34.8378 114.229 35.0838 114.034 35.3606 113.892C35.6373 113.75 35.9392 113.664 36.2492 113.638C36.7156 113.6 37.1829 113.7 37.592 113.927C38.0011 114.153 38.3332 114.495 38.5472 114.91ZM52.033 107.977C52.1929 108.288 52.2817 108.63 52.293 108.98C52.3043 109.329 52.2378 109.677 52.0983 109.998C51.9588 110.319 51.7498 110.605 51.4864 110.835C51.223 111.066 50.9117 111.236 50.575 111.332C50.2385 111.428 49.8851 111.448 49.5399 111.392C49.1948 111.335 48.8666 111.203 48.579 111.005C48.2913 110.806 48.0513 110.547 47.8762 110.244C47.7011 109.942 47.5953 109.605 47.5664 109.257C47.5409 108.947 47.5768 108.635 47.672 108.34C47.7672 108.044 47.9198 107.769 48.1211 107.532C48.3224 107.295 48.5685 107.1 48.8452 106.958C49.1219 106.816 49.4239 106.73 49.7338 106.705C50.2004 106.666 50.6678 106.766 51.077 106.992C51.4862 107.219 51.8189 107.561 52.033 107.977ZM65.5181 101.044C65.6781 101.355 65.767 101.697 65.7784 102.047C65.7898 102.396 65.7233 102.744 65.5838 103.065C65.4443 103.386 65.2352 103.672 64.9717 103.903C64.7082 104.133 64.3968 104.303 64.06 104.398C63.7236 104.495 63.3702 104.515 63.0251 104.458C62.6801 104.402 62.352 104.27 62.0644 104.071C61.7768 103.873 61.5369 103.613 61.3619 103.311C61.1869 103.008 61.0811 102.671 61.0522 102.323C61.0267 102.013 61.0626 101.702 61.1578 101.406C61.253 101.11 61.4056 100.836 61.6069 100.599C61.8082 100.362 62.0543 100.167 62.331 100.025C62.6077 99.8827 62.9097 99.7965 63.2196 99.7711C63.6861 99.7324 64.1534 99.8327 64.5625 100.059C64.9715 100.286 65.3041 100.628 65.5181 101.044ZM79.007 94.1088C79.167 94.4196 79.2559 94.7621 79.2673 95.1116C79.2786 95.4611 79.2122 95.8089 79.0727 96.1299C78.9332 96.4508 78.7241 96.7369 78.4606 96.9675C78.1971 97.1981 77.8857 97.3675 77.5489 97.4634C77.2125 97.5596 76.859 97.5802 76.5139 97.5237C76.1688 97.4671 75.8406 97.3349 75.553 97.1364C75.2654 96.9379 75.0254 96.6782 74.8504 96.3759C74.6755 96.0735 74.5698 95.7361 74.541 95.3879C74.509 95.0002 74.5733 94.6105 74.7282 94.2533C74.8831 93.8961 75.1238 93.5825 75.4289 93.3403C75.7341 93.0981 76.0942 92.9348 76.4775 92.8649C76.8607 92.7949 77.2551 92.8205 77.6258 92.9394C77.9217 93.034 78.196 93.186 78.433 93.3866C78.67 93.5873 78.865 93.8327 79.007 94.1088ZM92.492 87.1756C92.652 87.4864 92.7409 87.829 92.7523 88.1785C92.7637 88.528 92.6972 88.8758 92.5577 89.1967C92.4182 89.5177 92.2092 89.8038 91.9456 90.0344C91.6821 90.265 91.3707 90.4344 91.0339 90.5303C90.6975 90.6265 90.344 90.6471 89.9989 90.5906C89.6538 90.534 89.3257 90.4018 89.038 90.2033C88.7504 90.0048 88.5105 89.7451 88.3355 89.4428C88.1605 89.1404 88.0549 88.803 88.0261 88.4548C88.0006 88.1453 88.0365 87.8337 88.1317 87.5378C88.2269 87.242 88.3795 86.9677 88.5809 86.7307C88.7822 86.4937 89.0282 86.2986 89.3049 86.1565C89.5817 86.0145 89.8836 85.9283 90.1936 85.9029C90.66 85.8642 91.1273 85.9645 91.5364 86.191C91.9455 86.4175 92.278 86.7602 92.492 87.1756ZM105.978 80.2421C106.138 80.5529 106.227 80.8955 106.238 81.245C106.249 81.5945 106.183 81.9423 106.044 82.2632C105.904 82.5842 105.695 82.8703 105.431 83.1009C105.168 83.3315 104.857 83.5009 104.52 83.5968C104.183 83.6928 103.83 83.7133 103.485 83.6567C103.14 83.6001 102.812 83.4678 102.524 83.2694C102.237 83.0709 101.997 82.8113 101.822 82.509C101.647 82.2068 101.541 81.8694 101.512 81.5213C101.486 81.2118 101.522 80.9002 101.618 80.6043C101.713 80.3085 101.865 80.0342 102.067 79.7972C102.268 79.5602 102.514 79.3651 102.791 79.223C103.067 79.081 103.369 78.9948 103.679 78.9694C104.146 78.9307 104.613 79.031 105.022 79.2575C105.431 79.484 105.764 79.8267 105.978 80.2421ZM119.464 73.3086C119.678 73.7243 119.763 74.1942 119.709 74.6588C119.655 75.1235 119.465 75.5619 119.161 75.9185C118.858 76.2748 118.456 76.5335 118.006 76.6621C117.556 76.7907 117.079 76.7834 116.633 76.6411C116.188 76.4989 115.795 76.228 115.503 75.8626C115.212 75.4973 115.036 75.0538 114.997 74.5882C114.954 74.0433 115.1 73.5 115.412 73.0504C115.724 72.6009 116.182 72.2729 116.708 72.1222C117.235 71.9714 117.797 72.0072 118.299 72.2235C118.801 72.4398 119.213 72.8232 119.464 73.3086ZM132.949 66.3755C133.163 66.7911 133.248 67.2611 133.194 67.7257C133.141 68.1904 132.95 68.6288 132.646 68.9854C132.266 69.4314 131.733 69.7205 131.151 69.7969C130.57 69.8732 129.981 69.7312 129.499 69.3984C129.017 69.0657 128.676 68.5658 128.542 67.9957C128.408 67.4256 128.49 66.8258 128.774 66.3126C128.982 65.9384 129.289 65.6277 129.66 65.4135C130.031 65.1993 130.453 65.0896 130.882 65.096C131.31 65.1025 131.729 65.2249 132.093 65.4502C132.457 65.6755 132.752 65.9953 132.949 66.3755ZM32.018 102.211C32.178 102.522 32.2669 102.864 32.2783 103.214C32.2896 103.563 32.2232 103.911 32.0837 104.232C31.9442 104.553 31.7351 104.839 31.4716 105.07C31.2081 105.3 30.8967 105.47 30.5599 105.566C30.2236 105.662 29.8703 105.682 29.5253 105.625C29.1804 105.569 28.8523 105.437 28.5648 105.238C28.2773 105.04 28.0374 104.78 27.8624 104.478C27.6873 104.176 27.5815 103.839 27.5524 103.491C27.5142 103.025 27.6154 102.557 27.8432 102.148C28.0709 101.739 28.415 101.407 28.8318 101.193C29.3903 100.906 30.0396 100.852 30.6371 101.043C31.2346 101.234 31.731 101.654 32.018 102.211ZM45.5038 95.2774C45.6637 95.5883 45.7524 95.9308 45.7637 96.2802C45.775 96.6297 45.7085 96.9774 45.569 97.2983C45.4296 97.6192 45.2206 97.9053 44.9572 98.136C44.6937 98.3666 44.3824 98.5361 44.0457 98.6321C43.7093 98.7283 43.3558 98.7489 43.0107 98.6923C42.6656 98.6358 42.3374 98.5036 42.0497 98.3052C41.762 98.1068 41.522 97.8471 41.347 97.5448C41.1719 97.2426 41.0661 96.9052 41.0371 96.557C40.9989 96.0908 41.1001 95.6236 41.3278 95.2145C41.5556 94.8054 41.8996 94.4729 42.3164 94.2591C42.875 93.9722 43.5244 93.9183 44.122 94.1092C44.7196 94.3001 45.2166 94.7203 45.5038 95.2774ZM58.9888 88.3443C59.1489 88.6551 59.2378 88.9977 59.2491 89.3472C59.2605 89.6967 59.194 90.0445 59.0545 90.3654C58.915 90.6864 58.706 90.9725 58.4425 91.2031C58.179 91.4337 57.8676 91.6031 57.5308 91.699C57.1944 91.795 56.8409 91.8155 56.4959 91.7589C56.1508 91.7023 55.8227 91.57 55.5351 91.3716C55.2476 91.1731 55.0076 90.9135 54.8326 90.6112C54.6576 90.309 54.5518 89.9716 54.5229 89.6235C54.4847 89.1573 54.5859 88.6901 54.8136 88.281C55.0414 87.8719 55.3855 87.5394 55.8023 87.3256C56.3607 87.0387 57.0101 86.9848 57.6076 87.1759C58.2051 87.3669 58.7019 87.7872 58.9888 88.3443ZM72.4777 81.4092C72.6377 81.72 72.7267 82.0626 72.738 82.4121C72.7494 82.7616 72.6829 83.1094 72.5434 83.4303C72.4039 83.7513 72.1949 84.0374 71.9314 84.268C71.6678 84.4986 71.3564 84.668 71.0197 84.7639C70.6832 84.8601 70.3298 84.8807 69.9846 84.8242C69.6395 84.7676 69.3114 84.6354 69.0237 84.4369C68.7361 84.2384 68.4962 83.9787 68.3212 83.6764C68.1462 83.374 68.0406 83.0366 68.0118 82.6884C67.9799 82.3007 68.0443 81.911 68.1993 81.5539C68.3542 81.1968 68.595 80.8833 68.9001 80.6411C69.2053 80.399 69.5655 80.2358 69.9487 80.1659C70.3319 80.0961 70.7263 80.1217 71.0969 80.2407C71.6946 80.4312 72.1913 80.8522 72.4777 81.4092ZM85.9628 74.4761C86.1228 74.7869 86.2117 75.1295 86.2231 75.479C86.2344 75.8285 86.168 76.1763 86.0285 76.4972C85.889 76.8182 85.6799 77.1043 85.4164 77.3349C85.1529 77.5655 84.8415 77.7349 84.5047 77.8308C84.1683 77.927 83.8148 77.9476 83.4697 77.891C83.1246 77.8345 82.7964 77.7023 82.5088 77.5038C82.2212 77.3053 81.9812 77.0456 81.8063 76.7432C81.6313 76.4409 81.5256 76.1035 81.4968 75.7553C81.4586 75.2891 81.5598 74.8219 81.7876 74.4128C82.0153 74.0037 82.3594 73.6712 82.7762 73.4574C83.3347 73.1707 83.9839 73.117 84.5814 73.308C85.1788 73.499 85.6756 73.9191 85.9628 74.4761ZM99.4486 67.5426C99.6086 67.8534 99.6975 68.196 99.7089 68.5455C99.7202 68.895 99.6538 69.2428 99.5143 69.5637C99.3748 69.8847 99.1657 70.1708 98.9022 70.4014C98.6387 70.632 98.3273 70.8014 97.9905 70.8973C97.6541 70.9933 97.3007 71.0138 96.9556 70.9572C96.6106 70.9006 96.2825 70.7683 95.9949 70.5699C95.7073 70.3714 95.4674 70.1118 95.2924 69.8095C95.1173 69.5073 95.0116 69.1699 94.9826 68.8218C94.9572 68.5122 94.9931 68.2007 95.0883 67.9048C95.1835 67.609 95.3361 67.3347 95.5374 67.0977C95.7387 66.8607 95.9848 66.6656 96.2615 66.5235C96.5382 66.3815 96.8402 66.2953 97.1501 66.2698C97.6166 66.2312 98.0839 66.3314 98.4929 66.558C98.902 66.7845 99.2346 67.1271 99.4486 67.5426ZM112.934 60.6091C113.148 61.0248 113.234 61.4947 113.18 61.9593C113.126 62.424 112.936 62.8624 112.632 63.219C112.329 63.5753 111.927 63.834 111.477 63.9626C111.027 64.0912 110.549 64.0839 110.104 63.9416C109.658 63.7993 109.265 63.5285 108.974 63.1631C108.683 62.7978 108.507 62.3543 108.468 61.8887C108.424 61.3438 108.571 60.8005 108.883 60.3509C109.195 59.9014 109.653 59.5734 110.179 59.4227C110.705 59.2719 111.267 59.3077 111.77 59.524C112.272 59.7403 112.683 60.1237 112.934 60.6091ZM126.419 53.676C126.633 54.0916 126.719 54.5616 126.665 55.0262C126.611 55.4909 126.421 55.9293 126.117 56.2859C125.736 56.7319 125.204 57.021 124.622 57.0973C124.041 57.1737 123.452 57.0317 122.97 56.6989C122.487 56.3662 122.146 55.8663 122.012 55.2962C121.878 54.7261 121.961 54.1263 122.245 53.613C122.453 53.2389 122.759 52.9282 123.131 52.714C123.502 52.4998 123.924 52.3901 124.353 52.3965C124.781 52.403 125.199 52.5254 125.563 52.7507C125.927 52.976 126.223 53.2958 126.419 53.676ZM25.4887 89.5114C25.6488 89.8222 25.7377 90.1648 25.749 90.5143C25.7604 90.8638 25.6939 91.2116 25.5544 91.5325C25.4149 91.8535 25.2059 92.1396 24.9424 92.3702C24.6789 92.6008 24.3675 92.7702 24.0307 92.8661C23.6943 92.9621 23.341 92.9825 22.9961 92.9259C22.6511 92.8693 22.3231 92.7371 22.0356 92.5387C21.7481 92.3404 21.5082 92.0808 21.3331 91.7787C21.1581 91.4766 21.0522 91.1394 21.0232 90.7914C20.9913 90.4037 21.0557 90.014 21.2107 89.6569C21.3656 89.2997 21.6064 88.9862 21.9116 88.7441C22.2167 88.502 22.5769 88.3387 22.9601 88.2689C23.3433 88.199 23.7377 88.2247 24.1083 88.3436C24.706 88.5342 25.2023 88.9544 25.4887 89.5114ZM38.9749 82.5787C39.1348 82.8895 39.2236 83.232 39.2349 83.5815C39.2462 83.931 39.1797 84.2787 39.0402 84.5996C38.9007 84.9205 38.6917 85.2066 38.4283 85.4372C38.1649 85.6679 37.8536 85.8373 37.5169 85.9333C37.1804 86.0295 36.827 86.0501 36.4818 85.9936C36.1367 85.9371 35.8085 85.8048 35.5209 85.6064C35.2332 85.408 34.9932 85.1484 34.8181 84.8461C34.643 84.5438 34.5372 84.2065 34.5083 83.8582C34.47 83.3921 34.5712 82.9248 34.799 82.5158C35.0267 82.1067 35.3708 81.7742 35.7876 81.5603C36.346 81.2735 36.9952 81.2195 37.5927 81.4103C38.1902 81.6011 38.6876 82.0218 38.9749 82.5787ZM52.46 75.6456C52.62 75.9564 52.7089 76.2989 52.7203 76.6484C52.7317 76.9979 52.6652 77.3457 52.5257 77.6667C52.3862 77.9876 52.1771 78.2737 51.9136 78.5043C51.6501 78.735 51.3387 78.9043 51.0019 79.0002C50.6655 79.0963 50.3121 79.1167 49.967 79.0601C49.622 79.0035 49.2939 78.8713 49.0063 78.6728C48.7187 78.4744 48.4788 78.2147 48.3038 77.9125C48.1288 77.6102 48.023 77.2729 47.9941 76.9247C47.9559 76.4586 48.057 75.9913 48.2848 75.5823C48.5125 75.1732 48.8566 74.8407 49.2734 74.6268C49.8317 74.34 50.4809 74.2861 51.0783 74.477C51.6757 74.6679 52.1729 75.0886 52.46 75.6456ZM65.9489 68.7105C66.1089 69.0213 66.1978 69.3638 66.2092 69.7133C66.2205 70.0628 66.1541 70.4106 66.0146 70.7316C65.8751 71.0525 65.666 71.3387 65.4025 71.5693C65.139 71.7999 64.8276 71.9692 64.4908 72.0651C64.1544 72.1614 63.8009 72.1819 63.4558 72.1254C63.1107 72.0689 62.7825 71.9366 62.4949 71.7382C62.2073 71.5397 61.9673 71.2799 61.7924 70.9776C61.6174 70.6753 61.5117 70.3379 61.4829 69.9897C61.4509 69.602 61.5152 69.2122 61.6701 68.855C61.825 68.4979 62.0657 68.1842 62.3708 67.942C62.676 67.6998 63.0361 67.5365 63.4194 67.4666C63.8026 67.3967 64.197 67.4223 64.5677 67.5412C65.1657 67.7325 65.6624 68.1534 65.9489 68.7105ZM79.4339 61.7774C79.5939 62.0882 79.6828 62.4307 79.6942 62.7802C79.7056 63.1297 79.6391 63.4775 79.4996 63.7985C79.3601 64.1194 79.1511 64.4055 78.8875 64.6361C78.624 64.8668 78.3126 65.0361 77.9758 65.132C77.6394 65.2282 77.286 65.2488 76.9408 65.1923C76.5957 65.1358 76.2676 65.0035 75.9799 64.805C75.6923 64.6066 75.4524 64.3468 75.2774 64.0445C75.1024 63.7422 74.9968 63.4048 74.968 63.0565C74.9298 62.5904 75.031 62.1231 75.2587 61.7141C75.4865 61.305 75.8305 60.9725 76.2473 60.7586C76.8057 60.472 77.4548 60.4183 78.0521 60.6091C78.6494 60.8 79.1466 61.2206 79.4339 61.7774ZM92.9197 54.8439C93.0798 55.1547 93.1687 55.4972 93.18 55.8467C93.1914 56.1962 93.1249 56.544 92.9854 56.865C92.8459 57.1859 92.6369 57.472 92.3734 57.7026C92.1098 57.9333 91.7985 58.1026 91.4617 58.1985C91.1253 58.2946 90.7718 58.315 90.4268 58.2584C90.0817 58.2018 89.7536 58.0696 89.466 57.8711C89.1784 57.6727 88.9385 57.413 88.7635 57.1108C88.5885 56.8085 88.4827 56.4712 88.4538 56.123C88.4284 55.8135 88.4643 55.5019 88.5595 55.2061C88.6546 54.9102 88.8073 54.6359 89.0086 54.3989C89.2099 54.1619 89.4559 53.9668 89.7327 53.8247C90.0094 53.6827 90.3113 53.5965 90.6213 53.5711C91.0876 53.5324 91.5547 53.6326 91.9637 53.859C92.3727 54.0854 92.7056 54.4286 92.9197 54.8439ZM106.405 47.9096C106.619 48.3253 106.705 48.7952 106.651 49.2598C106.597 49.7245 106.406 50.1629 106.103 50.5195C105.8 50.8757 105.398 51.1345 104.948 51.2631C104.498 51.3917 104.02 51.3844 103.575 51.2421C103.129 51.0998 102.736 50.8289 102.445 50.4636C102.154 50.0982 101.978 49.6548 101.938 49.1892C101.907 48.8016 101.972 48.4122 102.127 48.0554C102.283 47.6986 102.523 47.3853 102.829 47.1433C103.134 46.9013 103.493 46.738 103.876 46.6679C104.259 46.5977 104.654 46.6228 105.024 46.741C105.621 46.932 106.119 47.3525 106.405 47.9096ZM119.891 40.9772C120.105 41.3929 120.19 41.8628 120.136 42.3275C120.083 42.7921 119.892 43.2306 119.588 43.5871C119.285 43.9435 118.883 44.2024 118.433 44.3311C117.983 44.4598 117.505 44.4525 117.06 44.3101C116.615 44.1678 116.222 43.8967 115.931 43.5312C115.639 43.1657 115.463 42.7221 115.425 42.2564C115.393 41.8689 115.458 41.4795 115.613 41.1226C115.768 40.7658 116.009 40.4525 116.314 40.2104C116.619 39.9683 116.979 39.805 117.362 39.7348C117.745 39.6646 118.139 39.6897 118.509 39.8079C119.107 39.9992 119.604 40.4202 119.891 40.9772ZM18.9128 76.7211C19.0728 77.0319 19.1617 77.3744 19.1731 77.724C19.1845 78.0735 19.118 78.4213 18.9785 78.7422C18.839 79.0632 18.63 79.3493 18.3664 79.5799C18.1029 79.8105 17.7915 79.9799 17.4547 80.0757C17.1183 80.1718 16.7649 80.1923 16.4198 80.1357C16.0748 80.0791 15.7467 79.9468 15.4591 79.7484C15.1715 79.5499 14.9316 79.2903 14.7566 78.988C14.5816 78.6858 14.4758 78.3484 14.4469 78.0003C14.415 77.6126 14.4794 77.2229 14.6344 76.8658C14.7893 76.5087 15.0301 76.1951 15.3352 75.953C15.6404 75.7109 16.0006 75.5476 16.3838 75.4778C16.767 75.4079 17.1614 75.4336 17.532 75.5525C17.8279 75.6469 18.1022 75.7987 18.3391 75.9993C18.576 76.1998 18.771 76.4451 18.9128 76.7211ZM32.3986 69.7876C32.5585 70.0984 32.6473 70.4409 32.6585 70.7904C32.6698 71.1399 32.6033 71.4876 32.4639 71.8085C32.3244 72.1294 32.1154 72.4155 31.852 72.6461C31.5886 72.8768 31.2773 73.0462 30.9406 73.1422C30.6041 73.2384 30.2506 73.259 29.9055 73.2025C29.5604 73.146 29.2322 73.0138 28.9445 72.8154C28.6569 72.6169 28.4169 72.3573 28.2418 72.055C28.0667 71.7527 27.9609 71.4154 27.9319 71.0672C27.8938 70.601 27.9951 70.1338 28.2228 69.7248C28.4505 69.3157 28.7945 68.9832 29.2113 68.7692C29.7698 68.4823 30.4192 68.4284 31.0168 68.6194C31.6144 68.8103 32.1114 69.2305 32.3986 69.7876ZM45.8837 62.8545C46.0437 63.1653 46.1326 63.5078 46.144 63.8573C46.1553 64.2068 46.0889 64.5546 45.9494 64.8756C45.8099 65.1965 45.6008 65.4826 45.3373 65.7133C45.0738 65.9439 44.7624 66.1132 44.4256 66.2091C44.0892 66.3052 43.7358 66.3257 43.3907 66.2691C43.0457 66.2124 42.7175 66.0802 42.43 65.8817C42.1424 65.6833 41.9025 65.4236 41.7274 65.1214C41.5524 64.8191 41.4467 64.4818 41.4177 64.1337C41.3859 63.746 41.4502 63.3563 41.6052 62.9992C41.7602 62.642 42.0009 62.3285 42.3061 62.0864C42.6113 61.8443 42.9714 61.681 43.3546 61.6112C43.7378 61.5413 44.1322 61.567 44.5029 61.6859C44.7988 61.7803 45.073 61.9321 45.31 62.1326C45.5469 62.3332 45.7419 62.5785 45.8837 62.8545ZM59.3725 55.9194C59.5326 56.2302 59.6215 56.5727 59.6328 56.9222C59.6442 57.2718 59.5777 57.6196 59.4382 57.9405C59.2987 58.2615 59.0897 58.5476 58.8262 58.7782C58.5627 59.0088 58.2513 59.1782 57.9145 59.274C57.5781 59.3703 57.2246 59.3909 56.8795 59.3343C56.5343 59.2778 56.2062 59.1455 55.9186 58.9471C55.6309 58.7486 55.391 58.4889 55.216 58.1865C55.0411 57.8842 54.9354 57.5468 54.9066 57.1986C54.8622 56.6535 55.0084 56.1095 55.3202 55.6595C55.632 55.2094 56.0902 54.881 56.6167 54.7302C57.1433 54.5794 57.7056 54.6155 58.208 54.8324C58.7103 55.0494 59.1223 55.4332 59.3725 55.9194ZM72.8576 48.9863C73.0176 49.2971 73.1065 49.6396 73.1179 49.9891C73.1292 50.3386 73.0628 50.6864 72.9233 51.0074C72.7838 51.3283 72.5747 51.6145 72.3112 51.8451C72.0477 52.0757 71.7363 52.245 71.3995 52.3409C71.0631 52.4372 70.7096 52.4577 70.3645 52.4012C70.0194 52.3447 69.6912 52.2124 69.4036 52.0139C69.116 51.8155 68.8761 51.5557 68.7011 51.2534C68.5261 50.9511 68.4204 50.6137 68.3917 50.2655C68.3598 49.8778 68.4242 49.4881 68.5791 49.131C68.7341 48.7738 68.9748 48.4603 69.28 48.2182C69.5852 47.9761 69.9453 47.8128 70.3285 47.743C70.7118 47.6731 71.1062 47.6988 71.4768 47.8177C71.7727 47.9121 72.0469 48.0639 72.2839 48.2644C72.5208 48.465 72.7158 48.7103 72.8576 48.9863ZM86.3434 42.0528C86.5034 42.3636 86.5923 42.7061 86.6037 43.0556C86.6151 43.4051 86.5486 43.7529 86.4091 44.0739C86.2696 44.3948 86.0605 44.6809 85.797 44.9116C85.5335 45.1422 85.2221 45.3115 84.8853 45.4074C84.5489 45.5035 84.1955 45.524 83.8504 45.4674C83.5054 45.4107 83.1773 45.2785 82.8897 45.08C82.6021 44.8816 82.3622 44.6219 82.1872 44.3197C82.0122 44.0174 81.9064 43.6801 81.8775 43.3319C81.8521 43.0224 81.8881 42.7109 81.9834 42.4151C82.0786 42.1193 82.2312 41.8451 82.4325 41.6081C82.6338 41.3711 82.8798 41.176 83.1565 41.0339C83.4331 40.8918 83.7351 40.8055 84.0449 40.78C84.5114 40.7413 84.9787 40.8416 85.3878 41.0681C85.7968 41.2947 86.1294 41.6373 86.3434 42.0528ZM99.8292 35.1193C100.043 35.5349 100.129 36.0049 100.075 36.4695C100.021 36.9341 99.8303 37.3726 99.527 37.7292C99.3002 37.9957 99.0173 38.2089 98.6985 38.3534C98.3796 38.4978 98.0328 38.5701 97.683 38.5648C97.3331 38.5596 96.9889 38.477 96.675 38.323C96.3611 38.169 96.0853 37.9475 95.8675 37.6742C95.6496 37.4009 95.4953 37.0824 95.4158 36.742C95.3362 36.4016 95.3334 36.0476 95.4076 35.7057C95.4817 35.3639 95.631 35.0426 95.8445 34.7652C96.058 34.4878 96.3305 34.2612 96.6422 34.1017C97.2007 33.8151 97.8498 33.7612 98.4473 33.952C99.0447 34.1428 99.5417 34.5625 99.8292 35.1193ZM113.314 28.1862C113.528 28.6018 113.614 29.0717 113.56 29.5364C113.506 30.0011 113.315 30.4395 113.012 30.796C112.709 31.1525 112.307 31.4113 111.857 31.54C111.407 31.6687 110.929 31.6614 110.484 31.519C110.038 31.3767 109.645 31.1056 109.354 30.7401C109.063 30.3746 108.887 29.931 108.848 29.4653C108.817 29.0779 108.882 28.6886 109.038 28.3319C109.193 27.9753 109.433 27.6621 109.738 27.4202C110.043 27.1783 110.403 27.015 110.786 26.9448C111.169 26.8745 111.563 26.8996 111.933 27.0176C112.229 27.112 112.504 27.2638 112.741 27.4643C112.978 27.6648 113.172 27.9101 113.314 28.1862ZM12.4302 64.1124C12.5904 64.4232 12.6795 64.7658 12.6909 65.1154C12.7024 65.465 12.636 65.8128 12.4965 66.1339C12.357 66.4549 12.148 66.7411 11.8844 66.9718C11.6209 67.2025 11.3094 67.3719 10.9726 67.4678C10.6361 67.5638 10.2826 67.5842 9.93751 67.5275C9.59241 67.4708 9.26428 67.3385 8.97668 67.14C8.68908 66.9415 8.44914 66.6817 8.2741 66.3794C8.09906 66.0771 7.99327 65.7398 7.96432 65.3916C7.93243 65.0039 7.99683 64.6142 8.15179 64.2571C8.30676 63.9 8.5475 63.5864 8.85267 63.3443C9.15784 63.1022 9.518 62.9389 9.90121 62.8691C10.2844 62.7992 10.6788 62.8249 11.0494 62.9438C11.6475 63.1352 12.1438 63.5553 12.4302 64.1124ZM25.916 57.1789C26.0761 57.4897 26.165 57.8323 26.1764 58.1818C26.1877 58.5314 26.1213 58.8792 25.9819 59.2002C25.8424 59.5212 25.6334 59.8073 25.37 60.0381C25.1065 60.2688 24.7952 60.4383 24.4584 60.5343C24.1219 60.6304 23.7683 60.6509 23.4232 60.5943C23.078 60.5377 22.7498 60.4054 22.4621 60.207C22.1744 60.0085 21.9344 59.7488 21.7593 59.4464C21.5842 59.1441 21.4783 58.8067 21.4494 58.4585C21.4112 57.9923 21.5123 57.525 21.7401 57.116C21.9678 56.7069 22.3119 56.3744 22.7287 56.1605C23.2873 55.8736 23.9366 55.8197 24.5342 56.0106C25.1319 56.2016 25.6288 56.6218 25.916 57.1789ZM39.4011 50.2458C39.6149 50.6614 39.7004 51.1311 39.6468 51.5957C39.5931 52.0602 39.4027 52.4986 39.0996 52.8553C38.873 53.122 38.5901 53.3353 38.2713 53.4799C37.9525 53.6245 37.6056 53.6969 37.2557 53.6917C36.9058 53.6866 36.5615 53.6041 36.2475 53.4502C35.9335 53.2963 35.6577 53.0747 35.4398 52.8015C35.222 52.528 35.0678 52.2094 34.9883 51.8689C34.9089 51.5284 34.9062 51.1744 34.9803 50.8325C35.0545 50.4905 35.2037 50.1692 35.4172 49.8917C35.6307 49.6142 35.9032 49.3874 36.2149 49.2278C36.7733 48.941 37.4224 48.8871 38.0198 49.078C38.6172 49.2688 39.114 49.6889 39.4011 50.2458ZM52.89 43.3107C53.1038 43.7264 53.1892 44.1963 53.1354 44.6609C53.0816 45.1255 52.891 45.5639 52.5877 45.9206C52.361 46.1871 52.0782 46.4003 51.7594 46.5448C51.4407 46.6893 51.0939 46.7615 50.7441 46.7564C50.3943 46.7512 50.0501 46.6687 49.7362 46.5148C49.4223 46.361 49.1465 46.1395 48.9286 45.8664C48.7111 45.5929 48.557 45.2744 48.4776 44.934C48.3983 44.5936 48.3955 44.2397 48.4696 43.8979C48.5437 43.5561 48.6927 43.2348 48.906 42.9573C49.1193 42.6798 49.3915 42.4529 49.703 42.2931C50.2614 42.006 50.9107 41.9519 51.5083 42.1427C52.1058 42.3336 52.6028 42.7536 52.89 43.3107ZM66.375 36.3776C66.5889 36.7932 66.6744 37.2629 66.6207 37.7275C66.567 38.192 66.3766 38.6304 66.0735 38.9871C65.8469 39.2538 65.564 39.4671 65.2452 39.6117C64.9264 39.7563 64.5796 39.8287 64.2296 39.8235C63.8797 39.8184 63.5354 39.7359 63.2215 39.582C62.9075 39.4281 62.6316 39.2065 62.4137 38.9333C62.1226 38.5675 61.947 38.1233 61.909 37.6573C61.871 37.1912 61.9725 36.7242 62.2005 36.3154C62.4092 35.9413 62.7155 35.6306 63.0867 35.4164C63.4579 35.2021 63.8802 35.0924 64.3086 35.0989C64.737 35.1053 65.1555 35.2277 65.5194 35.453C65.8834 35.6784 66.1788 35.9974 66.375 36.3776ZM79.8608 29.4441C80.0747 29.8598 80.1601 30.3297 80.1063 30.7943C80.0525 31.2589 79.8619 31.6973 79.5586 32.054C79.3319 32.3205 79.049 32.5337 78.7303 32.6782C78.4115 32.8227 78.0648 32.8949 77.715 32.8897C77.3652 32.8846 77.021 32.8021 76.7071 32.6482C76.3932 32.4943 76.1174 32.2729 75.8995 31.9998C75.6817 31.7263 75.5275 31.4077 75.4481 31.0672C75.3686 30.7267 75.3659 30.3727 75.44 30.0308C75.5142 29.6888 75.6634 29.3675 75.8769 29.09C76.0904 28.8125 76.3629 28.5857 76.6746 28.4261C77.233 28.1395 77.8821 28.0857 78.4794 28.2766C79.0767 28.4674 79.5736 28.8873 79.8608 29.4441ZM93.3466 22.5106C93.5606 22.9262 93.6461 23.3962 93.5923 23.8608C93.5385 24.3254 93.3478 24.7638 93.0444 25.1205C92.8177 25.387 92.5348 25.6001 92.2161 25.7446C91.8973 25.8892 91.5506 25.9614 91.2008 25.9562C90.851 25.9511 90.5068 25.8686 90.1929 25.7147C89.879 25.5608 89.6032 25.3394 89.3853 25.0663C89.1673 24.7929 89.0128 24.4745 88.9332 24.134C88.8536 23.7935 88.8507 23.4394 88.9248 23.0975C88.9989 22.7555 89.1481 22.4342 89.3617 22.1567C89.5753 21.8792 89.8478 21.6525 90.1597 21.493C90.7182 21.2063 91.3673 21.1525 91.9647 21.3433C92.5621 21.5341 93.0591 21.9538 93.3466 22.5106ZM106.832 15.5775C107.046 15.9931 107.131 16.463 107.077 16.9277C107.024 17.3924 106.833 17.8308 106.529 18.1873C106.303 18.454 106.02 18.6673 105.701 18.8119C105.382 18.9565 105.036 19.0288 104.686 19.0236C104.336 19.0184 103.992 18.9359 103.678 18.7819C103.364 18.628 103.088 18.4064 102.87 18.1332C102.579 17.7673 102.404 17.3232 102.366 16.8571C102.328 16.3911 102.429 15.924 102.657 15.5153C102.866 15.1412 103.172 14.8305 103.543 14.6162C103.915 14.402 104.337 14.2923 104.765 14.2987C105.194 14.3052 105.612 14.4276 105.976 14.6529C106.34 14.8782 106.635 15.1972 106.832 15.5775ZM5.90138 51.4137C6.06142 51.7245 6.15033 52.067 6.16169 52.4165C6.17305 52.766 6.10659 53.1138 5.96709 53.4348C5.82759 53.7557 5.61854 54.0418 5.35503 54.2724C5.09152 54.503 4.78013 54.6724 4.44333 54.7683C4.10691 54.8644 3.75348 54.8848 3.40843 54.8282C3.06338 54.7716 2.73527 54.6393 2.44769 54.4409C2.16011 54.2425 1.92019 53.9828 1.74517 53.6806C1.57015 53.3783 1.46438 53.041 1.43547 52.6928C1.40358 52.3051 1.46797 51.9155 1.62294 51.5583C1.77791 51.2012 2.01865 50.8877 2.32382 50.6455C2.62899 50.4034 2.98915 50.2402 3.37236 50.1703C3.75556 50.1005 4.14997 50.1262 4.52059 50.2451C4.81649 50.3395 5.09076 50.4913 5.3277 50.6918C5.56463 50.8923 5.75958 51.1376 5.90138 51.4137ZM19.3872 44.4802C19.5471 44.791 19.6359 45.1335 19.6471 45.4829C19.6584 45.8324 19.5919 46.1801 19.4524 46.501C19.313 46.822 19.104 47.108 18.8406 47.3387C18.5771 47.5693 18.2658 47.7388 17.9291 47.8348C17.5927 47.931 17.2392 47.9516 16.8941 47.895C16.549 47.8385 16.2208 47.7063 15.9331 47.5079C15.6455 47.3095 15.4055 47.0498 15.2304 46.7475C15.0553 46.4453 14.9495 46.1079 14.9205 45.7597C14.8951 45.4502 14.931 45.1386 15.0262 44.8427C15.1214 44.5469 15.274 44.2726 15.4753 44.0356C15.6766 43.7986 15.9226 43.6035 16.1994 43.4614C16.4761 43.3194 16.7781 43.2332 17.088 43.2078C17.5545 43.1689 18.0219 43.269 18.4312 43.4955C18.8404 43.722 19.1731 44.0646 19.3872 44.4802ZM32.8722 37.547C33.0323 37.8578 33.1212 38.2004 33.1326 38.5499C33.1439 38.8994 33.0774 39.2472 32.9379 39.5681C32.7984 39.8891 32.5894 40.1752 32.3259 40.4058C32.0624 40.6364 31.751 40.8058 31.4142 40.9017C31.0778 40.9977 30.7243 41.0182 30.3793 40.9616C30.0342 40.905 29.7061 40.7727 29.4186 40.5743C29.131 40.3758 28.891 40.1162 28.716 39.8139C28.541 39.5117 28.4352 39.1744 28.4063 38.8262C28.3744 38.4385 28.4388 38.0488 28.5938 37.6917C28.7488 37.3346 28.9895 37.021 29.2947 36.7789C29.5999 36.5368 29.96 36.3736 30.3432 36.3037C30.7264 36.2339 31.1208 36.2595 31.4914 36.3785C31.7873 36.4729 32.0616 36.6247 32.2986 36.8252C32.5355 37.0257 32.7304 37.271 32.8722 37.547ZM46.3611 30.612C46.5212 30.9228 46.6101 31.2653 46.6214 31.6148C46.6328 31.9643 46.5663 32.3121 46.4268 32.633C46.2873 32.954 46.0783 33.2401 45.8148 33.4707C45.5513 33.7013 45.2399 33.8707 44.9031 33.9666C44.5666 34.0627 44.2132 34.0831 43.8682 34.0265C43.5231 33.9699 43.195 33.8376 42.9074 33.6392C42.6198 33.4408 42.3799 33.1811 42.2049 32.8788C42.0299 32.5766 41.9241 32.2393 41.8952 31.8911C41.8508 31.346 41.9969 30.8021 42.3088 30.352C42.6206 29.9019 43.0788 29.5735 43.6053 29.4227C44.1319 29.2719 44.6942 29.3081 45.1965 29.525C45.6989 29.7419 46.1109 30.1258 46.3611 30.612ZM59.8462 23.6788C60.0062 23.9896 60.0951 24.3322 60.1065 24.6817C60.1178 25.0312 60.0514 25.379 59.9119 25.6999C59.7724 26.0209 59.5633 26.307 59.2998 26.5376C59.0363 26.7682 58.7249 26.9376 58.3881 27.0335C58.0517 27.1295 57.6983 27.15 57.3532 27.0934C57.0082 27.0368 56.6801 26.9045 56.3925 26.7061C56.1049 26.5077 55.865 26.248 55.69 25.9457C55.5149 25.6435 55.4092 25.3062 55.3802 24.958C55.3422 24.4918 55.4434 24.0247 55.6711 23.6156C55.8989 23.2065 56.2429 22.874 56.6596 22.6601C57.2181 22.3734 57.8673 22.3197 58.4648 22.5107C59.0622 22.7017 59.559 23.1218 59.8462 23.6788ZM73.332 16.7453C73.492 17.0561 73.5809 17.3987 73.5923 17.7482C73.6036 18.0977 73.5372 18.4455 73.3977 18.7664C73.2582 19.0874 73.0491 19.3735 72.7856 19.6041C72.5221 19.8347 72.2107 20.0041 71.8739 20.1C71.5375 20.196 71.1841 20.2165 70.839 20.1599C70.494 20.1033 70.1659 19.971 69.8783 19.7726C69.5907 19.5741 69.3508 19.3145 69.1758 19.0122C69.0007 18.71 68.895 18.3726 68.8661 18.0245C68.8279 17.5583 68.929 17.0911 69.1568 16.682C69.3845 16.2729 69.7286 15.9404 70.1454 15.7266C70.7039 15.4397 71.3532 15.3858 71.9507 15.5769C72.5482 15.7679 73.045 16.1882 73.332 16.7453ZM86.8178 9.81182C87.0317 10.2275 87.1172 10.6974 87.0634 11.162C87.0096 11.6267 86.8189 12.0651 86.5155 12.4217C86.2888 12.6883 86.0059 12.9014 85.687 13.0459C85.3682 13.1904 85.0214 13.2626 84.6716 13.2573C84.3217 13.2521 83.9775 13.1695 83.6636 13.0155C83.3497 12.8616 83.0739 12.64 82.8561 12.3668C82.638 12.0934 82.4836 11.775 82.404 11.4345C82.3243 11.094 82.3214 10.7399 82.3955 10.398C82.4697 10.056 82.6189 9.73464 82.8325 9.45715C83.046 9.17965 83.3186 8.95296 83.6304 8.79345C84.189 8.50677 84.8383 8.45298 85.4359 8.6439C86.0334 8.83482 86.5304 9.25485 86.8178 9.81182ZM100.303 2.87871C100.517 3.29433 100.602 3.76429 100.549 4.22895C100.495 4.69361 100.304 5.13203 100.001 5.48858C99.6974 5.84501 99.2955 6.10389 98.8455 6.23256C98.3956 6.36123 97.9177 6.35393 97.4723 6.21157C97.0269 6.06921 96.6339 5.79818 96.3428 5.43268C96.0517 5.06717 95.8757 4.62358 95.8369 4.15787C95.8059 3.77042 95.8709 3.38117 96.0261 3.02449C96.1813 2.66781 96.4221 2.35467 96.727 2.11274C97.0319 1.8708 97.3917 1.70752 97.7745 1.6373C98.1573 1.56708 98.5515 1.5921 98.922 1.71013C99.2179 1.80453 99.4922 1.95634 99.7292 2.15686C99.9661 2.35738 100.161 2.60268 100.303 2.87871Z"
                                    fill="currentColor"
                                />
                            </g>
                        </svg>
                        <svg
                            className="cs_shape_2 cs_accent_color"
                            width={148}
                            height={145}
                            viewBox="0 0 148 145"
                            fill="none"
                            xmlns="http://www.w3.org/2000/svg"
                        >
                            <mask id="mask0_12" style={{ maskType: "luminance" }} maskUnits="userSpaceOnUse" x={0} y={0} width={148} height={145}>
                                <path d="M0.609375 51.478L99.2245 0.776666L147.089 93.8749L48.4743 144.576L0.609375 51.478Z" fill="white" />
                            </mask>
                            <g mask="url(#mask0_12)">
                                <path
                                    d="M51.6057 140.309C51.82 140.725 51.9057 141.196 51.8522 141.661C51.7986 142.126 51.6081 142.564 51.3048 142.921C51.0015 143.279 50.5991 143.538 50.1484 143.667C49.6978 143.795 49.2193 143.787 48.7736 143.644C48.1761 143.453 47.6795 143.033 47.3928 142.476C47.1043 141.916 47.049 141.265 47.2391 140.664C47.4291 140.063 47.849 139.561 48.4074 139.268C48.9711 138.986 49.6228 138.938 50.2214 139.133C50.82 139.328 51.3173 139.75 51.6057 140.309ZM65.0908 133.376C65.2996 133.793 65.38 134.263 65.322 134.726C65.2639 135.189 65.07 135.624 64.7646 135.977C64.459 136.331 64.0559 136.586 63.6059 136.712C63.1559 136.837 62.679 136.828 62.2349 136.684C61.7907 136.54 61.3994 136.267 61.1103 135.901C60.8213 135.534 60.6474 135.091 60.6108 134.625C60.5742 134.16 60.6763 133.694 60.9044 133.287C61.1325 132.879 61.4763 132.548 61.8924 132.335C62.1711 132.192 62.4752 132.105 62.7874 132.08C63.0996 132.054 63.4136 132.091 63.7113 132.188C64.0087 132.285 64.2837 132.44 64.5205 132.644C64.7573 132.848 64.9512 133.097 65.0908 133.376ZM78.5766 126.443C78.7854 126.86 78.8658 127.329 78.8078 127.792C78.7497 128.255 78.5558 128.691 78.2504 129.044C77.9448 129.397 77.5417 129.653 77.0917 129.778C76.6417 129.904 76.1648 129.894 75.7207 129.75C75.1999 129.582 74.7541 129.238 74.4592 128.777C74.1644 128.316 74.0388 127.768 74.1039 127.224C74.169 126.681 74.4208 126.177 74.8163 125.798C75.2118 125.419 75.7264 125.188 76.2725 125.146C76.5846 125.121 76.8983 125.159 77.1958 125.256C77.4932 125.353 77.7685 125.507 78.0059 125.711C78.2428 125.914 78.4364 126.163 78.5766 126.443ZM92.0654 119.508C92.2217 119.82 92.3068 120.162 92.3147 120.511C92.3226 120.86 92.253 121.207 92.111 121.526C91.969 121.845 91.758 122.128 91.4933 122.356C91.2285 122.584 90.9166 122.751 90.5799 122.845C90.13 122.969 89.6534 122.959 89.2098 122.814C88.7663 122.67 88.3754 122.398 88.0861 122.032C87.8701 121.758 87.7176 121.44 87.6395 121.1C87.5613 120.761 87.5594 120.408 87.634 120.067C87.7086 119.726 87.8578 119.406 88.0709 119.129C88.2839 118.852 88.5556 118.626 88.8663 118.467C89.145 118.323 89.4492 118.237 89.7613 118.211C90.0735 118.186 90.3875 118.223 90.6852 118.32C90.9827 118.416 91.2578 118.571 91.4948 118.775C91.7317 118.979 91.9257 119.228 92.0654 119.508ZM105.55 112.575C105.759 112.992 105.84 113.461 105.782 113.924C105.723 114.387 105.53 114.822 105.224 115.176C104.919 115.529 104.516 115.784 104.066 115.91C103.616 116.036 103.139 116.026 102.695 115.882C102.25 115.738 101.859 115.465 101.57 115.099C101.281 114.733 101.107 114.289 101.071 113.824C101.034 113.358 101.136 112.893 101.364 112.485C101.592 112.077 101.936 111.746 102.352 111.533C102.631 111.39 102.935 111.303 103.247 111.278C103.559 111.253 103.873 111.29 104.17 111.387C104.468 111.483 104.743 111.638 104.98 111.842C105.217 112.046 105.411 112.295 105.55 112.575ZM119.036 105.641C119.245 106.058 119.325 106.528 119.267 106.991C119.209 107.454 119.015 107.889 118.709 108.243C118.404 108.596 118.001 108.851 117.551 108.976C117.101 109.102 116.624 109.092 116.18 108.948C115.736 108.804 115.345 108.532 115.056 108.166C114.767 107.8 114.593 107.356 114.556 106.891C114.52 106.425 114.622 105.96 114.85 105.552C115.078 105.144 115.421 104.813 115.837 104.6C116.116 104.457 116.42 104.37 116.732 104.345C117.044 104.32 117.358 104.356 117.656 104.453C117.954 104.55 118.229 104.705 118.466 104.909C118.703 105.113 118.897 105.362 119.036 105.641ZM132.522 98.7077C132.704 99.072 132.789 99.4773 132.768 99.8843C132.748 100.291 132.622 100.686 132.404 101.031C132.185 101.375 131.881 101.658 131.522 101.85C131.162 102.043 130.759 102.14 130.351 102.132C129.943 102.123 129.545 102.009 129.194 101.801C128.843 101.594 128.553 101.299 128.35 100.945C128.147 100.592 128.039 100.192 128.037 99.7846C128.035 99.3771 128.138 98.9758 128.336 98.6195C128.604 98.1403 129.031 97.7686 129.542 97.5681C130.054 97.3675 130.619 97.3505 131.141 97.5199C131.439 97.6169 131.714 97.7718 131.951 97.9757C132.188 98.1795 132.382 98.4283 132.522 98.7077ZM146.007 91.7745C146.164 92.0863 146.249 92.429 146.257 92.7778C146.265 93.1266 146.195 93.473 146.053 93.792C145.911 94.111 145.7 94.3948 145.436 94.6228C145.171 94.8509 144.859 95.0176 144.522 95.1111C144.072 95.2364 143.596 95.2262 143.152 95.0817C142.708 94.9373 142.317 94.6649 142.028 94.299C141.739 93.933 141.565 93.4894 141.528 93.0243C141.491 92.5591 141.594 92.0934 141.822 91.686C141.993 91.3794 142.231 91.1147 142.517 90.911C142.804 90.7073 143.132 90.5696 143.478 90.508C143.824 90.4464 144.179 90.4624 144.518 90.5548C144.856 90.6472 145.17 90.8138 145.436 91.0424C145.673 91.2457 145.867 91.4944 146.007 91.7745ZM45.0765 127.61C45.2184 127.886 45.3044 128.187 45.3296 128.497C45.3549 128.806 45.3188 129.118 45.2236 129.414C45.1283 129.709 44.9757 129.984 44.7745 130.221C44.5732 130.458 44.3273 130.653 44.0507 130.795C43.7741 130.937 43.4722 131.023 43.1624 131.049C42.8526 131.075 42.5408 131.039 42.2449 130.945C41.9489 130.85 41.6747 130.698 41.4377 130.497C41.2008 130.296 41.0058 130.051 40.8639 129.775C40.5773 129.217 40.5244 128.568 40.7168 127.971C40.9092 127.374 41.3311 126.877 41.8897 126.59C42.4483 126.303 43.0979 126.249 43.6955 126.44C44.2932 126.632 44.7899 127.052 45.0765 127.61ZM58.5623 120.676C58.7041 120.953 58.7901 121.254 58.8153 121.564C58.8405 121.873 58.8044 122.185 58.7091 122.481C58.6138 122.776 58.4611 123.051 58.2598 123.288C58.0584 123.525 57.8124 123.72 57.5357 123.862C57.2591 124.004 56.9572 124.09 56.6472 124.116C56.3373 124.142 56.0255 124.106 55.7295 124.011C55.4336 123.916 55.1593 123.764 54.9224 123.563C54.6854 123.363 54.4904 123.117 54.3486 122.841C54.2067 122.565 54.1207 122.263 54.0956 121.954C54.0704 121.644 54.1065 121.333 54.2018 121.037C54.2971 120.741 54.4497 120.467 54.651 120.23C54.8523 119.993 55.0983 119.798 55.3749 119.656C55.6515 119.514 55.9534 119.428 56.2633 119.402C56.5731 119.377 56.8849 119.412 57.1808 119.507C57.4767 119.602 57.7509 119.754 57.9878 119.955C58.2247 120.155 58.4197 120.401 58.5615 120.677L58.5623 120.676ZM72.0473 113.743C72.1963 114.02 72.2884 114.324 72.3185 114.637C72.3485 114.949 72.3158 115.265 72.2222 115.565C72.1287 115.866 71.9761 116.144 71.7736 116.385C71.571 116.626 71.3225 116.824 71.0425 116.968C70.7625 117.112 70.4567 117.199 70.143 117.223C69.8292 117.248 69.5138 117.209 69.2152 117.111C68.9166 117.012 68.6408 116.855 68.4039 116.648C68.167 116.442 67.9738 116.19 67.8355 115.908C67.549 115.35 67.496 114.701 67.6884 114.104C67.8808 113.507 68.3027 113.01 68.8613 112.723C69.4199 112.436 70.0695 112.382 70.6671 112.573C71.2648 112.765 71.7608 113.186 72.0473 113.743ZM85.5362 106.808C85.6781 107.084 85.7641 107.386 85.7894 107.695C85.8146 108.005 85.7786 108.316 85.6833 108.612C85.5881 108.908 85.4355 109.182 85.2342 109.419C85.033 109.656 84.787 109.851 84.5104 109.993C84.2338 110.135 83.932 110.222 83.6221 110.247C83.3123 110.273 83.0005 110.238 82.7046 110.143C82.4087 110.048 82.1344 109.896 81.8975 109.695C81.6605 109.495 81.4655 109.249 81.3236 108.973C81.0371 108.415 80.9842 107.767 81.1765 107.169C81.3689 106.572 81.7908 106.075 82.3494 105.788C82.908 105.501 83.5576 105.447 84.1553 105.639C84.7529 105.83 85.2496 106.251 85.5362 106.808ZM99.0213 99.8752C99.1702 100.152 99.2624 100.455 99.2924 100.768C99.3224 101.081 99.2897 101.397 99.1961 101.697C99.1026 101.998 98.9501 102.276 98.7475 102.517C98.5449 102.758 98.2964 102.956 98.0164 103.1C97.7365 103.244 97.4307 103.331 97.1169 103.355C96.8032 103.38 96.4878 103.341 96.1892 103.243C95.8906 103.144 95.6148 102.987 95.3779 102.78C95.1409 102.574 94.9477 102.322 94.8095 102.04C94.6676 101.764 94.5815 101.462 94.5563 101.153C94.531 100.843 94.5671 100.532 94.6623 100.236C94.7576 99.9401 94.9102 99.6659 95.1114 99.4289C95.3127 99.1919 95.5586 98.9968 95.8352 98.8547C96.1118 98.7125 96.4137 98.6261 96.7235 98.6005C97.0334 98.5748 97.3451 98.6104 97.6411 98.7051C97.937 98.7998 98.2112 98.9519 98.4482 99.1526C98.6851 99.3532 98.8794 99.5991 99.0213 99.8752ZM112.507 92.9416C112.656 93.2183 112.748 93.522 112.778 93.8348C112.808 94.1477 112.776 94.4635 112.682 94.7638C112.588 95.064 112.436 95.3427 112.233 95.5836C112.031 95.8244 111.782 96.0226 111.502 96.1665C111.222 96.3103 110.916 96.3971 110.603 96.4216C110.289 96.446 109.974 96.4078 109.675 96.3091C109.376 96.2103 109.101 96.0531 108.864 95.8465C108.627 95.64 108.434 95.3883 108.295 95.1061C108.009 94.5485 107.956 93.8997 108.148 93.3024C108.341 92.7051 108.762 92.2082 109.321 91.9211C109.88 91.6341 110.529 91.5803 111.127 91.7716C111.725 91.9629 112.22 92.384 112.507 92.9416ZM125.993 86.0081C126.153 86.319 126.242 86.6615 126.253 87.011C126.264 87.3605 126.198 87.7083 126.058 88.0292C125.919 88.3502 125.71 88.6363 125.447 88.8671C125.183 89.0978 124.872 89.2674 124.535 89.3635C124.085 89.492 123.607 89.4845 123.161 89.3421C122.716 89.1996 122.323 88.9286 122.031 88.5631C121.813 88.2897 121.659 87.9713 121.579 87.6309C121.5 87.2904 121.497 86.9365 121.571 86.5946C121.645 86.2527 121.795 85.9315 122.008 85.6541C122.222 85.3767 122.494 85.15 122.806 84.9905C123.364 84.7034 124.014 84.6494 124.611 84.8402C125.209 85.031 125.706 85.4511 125.993 86.0081ZM139.478 79.075C139.638 79.3859 139.727 79.7284 139.738 80.0779C139.75 80.4275 139.683 80.7753 139.544 81.0963C139.404 81.4173 139.195 81.7035 138.932 81.9342C138.668 82.1649 138.357 82.3344 138.02 82.4304C137.57 82.5587 137.092 82.5512 136.646 82.4088C136.201 82.2663 135.808 81.9954 135.516 81.63C135.225 81.2641 135.049 80.82 135.012 80.3539C134.974 79.8879 135.075 79.4209 135.303 79.0121C135.511 78.637 135.817 78.3253 136.188 78.1103C136.56 77.8954 136.982 77.7852 137.411 77.7917C137.84 77.7982 138.259 77.921 138.623 78.147C138.987 78.3731 139.283 78.6939 139.478 79.075ZM38.5472 114.91C38.7073 115.221 38.7962 115.564 38.8075 115.913C38.8189 116.263 38.7524 116.611 38.6129 116.932C38.4734 117.253 38.2644 117.539 38.0009 117.769C37.7374 118 37.426 118.169 37.0892 118.265C36.7528 118.361 36.3995 118.382 36.0546 118.325C35.7096 118.268 35.3816 118.136 35.0941 117.938C34.8065 117.739 34.5666 117.48 34.3916 117.178C34.2166 116.876 34.1107 116.538 34.0817 116.19C34.0563 115.881 34.0922 115.569 34.1873 115.273C34.2825 114.978 34.4352 114.703 34.6365 114.466C34.8378 114.229 35.0838 114.034 35.3606 113.892C35.6373 113.75 35.9392 113.664 36.2492 113.638C36.7156 113.6 37.1829 113.7 37.592 113.927C38.0011 114.153 38.3332 114.495 38.5472 114.91ZM52.033 107.977C52.1929 108.288 52.2817 108.63 52.293 108.98C52.3043 109.329 52.2378 109.677 52.0983 109.998C51.9588 110.319 51.7498 110.605 51.4864 110.835C51.223 111.066 50.9117 111.236 50.575 111.332C50.2385 111.428 49.8851 111.448 49.5399 111.392C49.1948 111.335 48.8666 111.203 48.579 111.005C48.2913 110.806 48.0513 110.547 47.8762 110.244C47.7011 109.942 47.5953 109.605 47.5664 109.257C47.5409 108.947 47.5768 108.635 47.672 108.34C47.7672 108.044 47.9198 107.769 48.1211 107.532C48.3224 107.295 48.5685 107.1 48.8452 106.958C49.1219 106.816 49.4239 106.73 49.7338 106.705C50.2004 106.666 50.6678 106.766 51.077 106.992C51.4862 107.219 51.8189 107.561 52.033 107.977ZM65.5181 101.044C65.6781 101.355 65.767 101.697 65.7784 102.047C65.7898 102.396 65.7233 102.744 65.5838 103.065C65.4443 103.386 65.2352 103.672 64.9717 103.903C64.7082 104.133 64.3968 104.303 64.06 104.398C63.7236 104.495 63.3702 104.515 63.0251 104.458C62.6801 104.402 62.352 104.27 62.0644 104.071C61.7768 103.873 61.5369 103.613 61.3619 103.311C61.1869 103.008 61.0811 102.671 61.0522 102.323C61.0267 102.013 61.0626 101.702 61.1578 101.406C61.253 101.11 61.4056 100.836 61.6069 100.599C61.8082 100.362 62.0543 100.167 62.331 100.025C62.6077 99.8827 62.9097 99.7965 63.2196 99.7711C63.6861 99.7324 64.1534 99.8327 64.5625 100.059C64.9715 100.286 65.3041 100.628 65.5181 101.044ZM79.007 94.1088C79.167 94.4196 79.2559 94.7621 79.2673 95.1116C79.2786 95.4611 79.2122 95.8089 79.0727 96.1299C78.9332 96.4508 78.7241 96.7369 78.4606 96.9675C78.1971 97.1981 77.8857 97.3675 77.5489 97.4634C77.2125 97.5596 76.859 97.5802 76.5139 97.5237C76.1688 97.4671 75.8406 97.3349 75.553 97.1364C75.2654 96.9379 75.0254 96.6782 74.8504 96.3759C74.6755 96.0735 74.5698 95.7361 74.541 95.3879C74.509 95.0002 74.5733 94.6105 74.7282 94.2533C74.8831 93.8961 75.1238 93.5825 75.4289 93.3403C75.7341 93.0981 76.0942 92.9348 76.4775 92.8649C76.8607 92.7949 77.2551 92.8205 77.6258 92.9394C77.9217 93.034 78.196 93.186 78.433 93.3866C78.67 93.5873 78.865 93.8327 79.007 94.1088ZM92.492 87.1756C92.652 87.4864 92.7409 87.829 92.7523 88.1785C92.7637 88.528 92.6972 88.8758 92.5577 89.1967C92.4182 89.5177 92.2092 89.8038 91.9456 90.0344C91.6821 90.265 91.3707 90.4344 91.0339 90.5303C90.6975 90.6265 90.344 90.6471 89.9989 90.5906C89.6538 90.534 89.3257 90.4018 89.038 90.2033C88.7504 90.0048 88.5105 89.7451 88.3355 89.4428C88.1605 89.1404 88.0549 88.803 88.0261 88.4548C88.0006 88.1453 88.0365 87.8337 88.1317 87.5378C88.2269 87.242 88.3795 86.9677 88.5809 86.7307C88.7822 86.4937 89.0282 86.2986 89.3049 86.1565C89.5817 86.0145 89.8836 85.9283 90.1936 85.9029C90.66 85.8642 91.1273 85.9645 91.5364 86.191C91.9455 86.4175 92.278 86.7602 92.492 87.1756ZM105.978 80.2421C106.138 80.5529 106.227 80.8955 106.238 81.245C106.249 81.5945 106.183 81.9423 106.044 82.2632C105.904 82.5842 105.695 82.8703 105.431 83.1009C105.168 83.3315 104.857 83.5009 104.52 83.5968C104.183 83.6928 103.83 83.7133 103.485 83.6567C103.14 83.6001 102.812 83.4678 102.524 83.2694C102.237 83.0709 101.997 82.8113 101.822 82.509C101.647 82.2068 101.541 81.8694 101.512 81.5213C101.486 81.2118 101.522 80.9002 101.618 80.6043C101.713 80.3085 101.865 80.0342 102.067 79.7972C102.268 79.5602 102.514 79.3651 102.791 79.223C103.067 79.081 103.369 78.9948 103.679 78.9694C104.146 78.9307 104.613 79.031 105.022 79.2575C105.431 79.484 105.764 79.8267 105.978 80.2421ZM119.464 73.3086C119.678 73.7243 119.763 74.1942 119.709 74.6588C119.655 75.1235 119.465 75.5619 119.161 75.9185C118.858 76.2748 118.456 76.5335 118.006 76.6621C117.556 76.7907 117.079 76.7834 116.633 76.6411C116.188 76.4989 115.795 76.228 115.503 75.8626C115.212 75.4973 115.036 75.0538 114.997 74.5882C114.954 74.0433 115.1 73.5 115.412 73.0504C115.724 72.6009 116.182 72.2729 116.708 72.1222C117.235 71.9714 117.797 72.0072 118.299 72.2235C118.801 72.4398 119.213 72.8232 119.464 73.3086ZM132.949 66.3755C133.163 66.7911 133.248 67.2611 133.194 67.7257C133.141 68.1904 132.95 68.6288 132.646 68.9854C132.266 69.4314 131.733 69.7205 131.151 69.7969C130.57 69.8732 129.981 69.7312 129.499 69.3984C129.017 69.0657 128.676 68.5658 128.542 67.9957C128.408 67.4256 128.49 66.8258 128.774 66.3126C128.982 65.9384 129.289 65.6277 129.66 65.4135C130.031 65.1993 130.453 65.0896 130.882 65.096C131.31 65.1025 131.729 65.2249 132.093 65.4502C132.457 65.6755 132.752 65.9953 132.949 66.3755ZM32.018 102.211C32.178 102.522 32.2669 102.864 32.2783 103.214C32.2896 103.563 32.2232 103.911 32.0837 104.232C31.9442 104.553 31.7351 104.839 31.4716 105.07C31.2081 105.3 30.8967 105.47 30.5599 105.566C30.2236 105.662 29.8703 105.682 29.5253 105.625C29.1804 105.569 28.8523 105.437 28.5648 105.238C28.2773 105.04 28.0374 104.78 27.8624 104.478C27.6873 104.176 27.5815 103.839 27.5524 103.491C27.5142 103.025 27.6154 102.557 27.8432 102.148C28.0709 101.739 28.415 101.407 28.8318 101.193C29.3903 100.906 30.0396 100.852 30.6371 101.043C31.2346 101.234 31.731 101.654 32.018 102.211ZM45.5038 95.2774C45.6637 95.5883 45.7524 95.9308 45.7637 96.2802C45.775 96.6297 45.7085 96.9774 45.569 97.2983C45.4296 97.6192 45.2206 97.9053 44.9572 98.136C44.6937 98.3666 44.3824 98.5361 44.0457 98.6321C43.7093 98.7283 43.3558 98.7489 43.0107 98.6923C42.6656 98.6358 42.3374 98.5036 42.0497 98.3052C41.762 98.1068 41.522 97.8471 41.347 97.5448C41.1719 97.2426 41.0661 96.9052 41.0371 96.557C40.9989 96.0908 41.1001 95.6236 41.3278 95.2145C41.5556 94.8054 41.8996 94.4729 42.3164 94.2591C42.875 93.9722 43.5244 93.9183 44.122 94.1092C44.7196 94.3001 45.2166 94.7203 45.5038 95.2774ZM58.9888 88.3443C59.1489 88.6551 59.2378 88.9977 59.2491 89.3472C59.2605 89.6967 59.194 90.0445 59.0545 90.3654C58.915 90.6864 58.706 90.9725 58.4425 91.2031C58.179 91.4337 57.8676 91.6031 57.5308 91.699C57.1944 91.795 56.8409 91.8155 56.4959 91.7589C56.1508 91.7023 55.8227 91.57 55.5351 91.3716C55.2476 91.1731 55.0076 90.9135 54.8326 90.6112C54.6576 90.309 54.5518 89.9716 54.5229 89.6235C54.4847 89.1573 54.5859 88.6901 54.8136 88.281C55.0414 87.8719 55.3855 87.5394 55.8023 87.3256C56.3607 87.0387 57.0101 86.9848 57.6076 87.1759C58.2051 87.3669 58.7019 87.7872 58.9888 88.3443ZM72.4777 81.4092C72.6377 81.72 72.7267 82.0626 72.738 82.4121C72.7494 82.7616 72.6829 83.1094 72.5434 83.4303C72.4039 83.7513 72.1949 84.0374 71.9314 84.268C71.6678 84.4986 71.3564 84.668 71.0197 84.7639C70.6832 84.8601 70.3298 84.8807 69.9846 84.8242C69.6395 84.7676 69.3114 84.6354 69.0237 84.4369C68.7361 84.2384 68.4962 83.9787 68.3212 83.6764C68.1462 83.374 68.0406 83.0366 68.0118 82.6884C67.9799 82.3007 68.0443 81.911 68.1993 81.5539C68.3542 81.1968 68.595 80.8833 68.9001 80.6411C69.2053 80.399 69.5655 80.2358 69.9487 80.1659C70.3319 80.0961 70.7263 80.1217 71.0969 80.2407C71.6946 80.4312 72.1913 80.8522 72.4777 81.4092ZM85.9628 74.4761C86.1228 74.7869 86.2117 75.1295 86.2231 75.479C86.2344 75.8285 86.168 76.1763 86.0285 76.4972C85.889 76.8182 85.6799 77.1043 85.4164 77.3349C85.1529 77.5655 84.8415 77.7349 84.5047 77.8308C84.1683 77.927 83.8148 77.9476 83.4697 77.891C83.1246 77.8345 82.7964 77.7023 82.5088 77.5038C82.2212 77.3053 81.9812 77.0456 81.8063 76.7432C81.6313 76.4409 81.5256 76.1035 81.4968 75.7553C81.4586 75.2891 81.5598 74.8219 81.7876 74.4128C82.0153 74.0037 82.3594 73.6712 82.7762 73.4574C83.3347 73.1707 83.9839 73.117 84.5814 73.308C85.1788 73.499 85.6756 73.9191 85.9628 74.4761ZM99.4486 67.5426C99.6086 67.8534 99.6975 68.196 99.7089 68.5455C99.7202 68.895 99.6538 69.2428 99.5143 69.5637C99.3748 69.8847 99.1657 70.1708 98.9022 70.4014C98.6387 70.632 98.3273 70.8014 97.9905 70.8973C97.6541 70.9933 97.3007 71.0138 96.9556 70.9572C96.6106 70.9006 96.2825 70.7683 95.9949 70.5699C95.7073 70.3714 95.4674 70.1118 95.2924 69.8095C95.1173 69.5073 95.0116 69.1699 94.9826 68.8218C94.9572 68.5122 94.9931 68.2007 95.0883 67.9048C95.1835 67.609 95.3361 67.3347 95.5374 67.0977C95.7387 66.8607 95.9848 66.6656 96.2615 66.5235C96.5382 66.3815 96.8402 66.2953 97.1501 66.2698C97.6166 66.2312 98.0839 66.3314 98.4929 66.558C98.902 66.7845 99.2346 67.1271 99.4486 67.5426ZM112.934 60.6091C113.148 61.0248 113.234 61.4947 113.18 61.9593C113.126 62.424 112.936 62.8624 112.632 63.219C112.329 63.5753 111.927 63.834 111.477 63.9626C111.027 64.0912 110.549 64.0839 110.104 63.9416C109.658 63.7993 109.265 63.5285 108.974 63.1631C108.683 62.7978 108.507 62.3543 108.468 61.8887C108.424 61.3438 108.571 60.8005 108.883 60.3509C109.195 59.9014 109.653 59.5734 110.179 59.4227C110.705 59.2719 111.267 59.3077 111.77 59.524C112.272 59.7403 112.683 60.1237 112.934 60.6091ZM126.419 53.676C126.633 54.0916 126.719 54.5616 126.665 55.0262C126.611 55.4909 126.421 55.9293 126.117 56.2859C125.736 56.7319 125.204 57.021 124.622 57.0973C124.041 57.1737 123.452 57.0317 122.97 56.6989C122.487 56.3662 122.146 55.8663 122.012 55.2962C121.878 54.7261 121.961 54.1263 122.245 53.613C122.453 53.2389 122.759 52.9282 123.131 52.714C123.502 52.4998 123.924 52.3901 124.353 52.3965C124.781 52.403 125.199 52.5254 125.563 52.7507C125.927 52.976 126.223 53.2958 126.419 53.676ZM25.4887 89.5114C25.6488 89.8222 25.7377 90.1648 25.749 90.5143C25.7604 90.8638 25.6939 91.2116 25.5544 91.5325C25.4149 91.8535 25.2059 92.1396 24.9424 92.3702C24.6789 92.6008 24.3675 92.7702 24.0307 92.8661C23.6943 92.9621 23.341 92.9825 22.9961 92.9259C22.6511 92.8693 22.3231 92.7371 22.0356 92.5387C21.7481 92.3404 21.5082 92.0808 21.3331 91.7787C21.1581 91.4766 21.0522 91.1394 21.0232 90.7914C20.9913 90.4037 21.0557 90.014 21.2107 89.6569C21.3656 89.2997 21.6064 88.9862 21.9116 88.7441C22.2167 88.502 22.5769 88.3387 22.9601 88.2689C23.3433 88.199 23.7377 88.2247 24.1083 88.3436C24.706 88.5342 25.2023 88.9544 25.4887 89.5114ZM38.9749 82.5787C39.1348 82.8895 39.2236 83.232 39.2349 83.5815C39.2462 83.931 39.1797 84.2787 39.0402 84.5996C38.9007 84.9205 38.6917 85.2066 38.4283 85.4372C38.1649 85.6679 37.8536 85.8373 37.5169 85.9333C37.1804 86.0295 36.827 86.0501 36.4818 85.9936C36.1367 85.9371 35.8085 85.8048 35.5209 85.6064C35.2332 85.408 34.9932 85.1484 34.8181 84.8461C34.643 84.5438 34.5372 84.2065 34.5083 83.8582C34.47 83.3921 34.5712 82.9248 34.799 82.5158C35.0267 82.1067 35.3708 81.7742 35.7876 81.5603C36.346 81.2735 36.9952 81.2195 37.5927 81.4103C38.1902 81.6011 38.6876 82.0218 38.9749 82.5787ZM52.46 75.6456C52.62 75.9564 52.7089 76.2989 52.7203 76.6484C52.7317 76.9979 52.6652 77.3457 52.5257 77.6667C52.3862 77.9876 52.1771 78.2737 51.9136 78.5043C51.6501 78.735 51.3387 78.9043 51.0019 79.0002C50.6655 79.0963 50.3121 79.1167 49.967 79.0601C49.622 79.0035 49.2939 78.8713 49.0063 78.6728C48.7187 78.4744 48.4788 78.2147 48.3038 77.9125C48.1288 77.6102 48.023 77.2729 47.9941 76.9247C47.9559 76.4586 48.057 75.9913 48.2848 75.5823C48.5125 75.1732 48.8566 74.8407 49.2734 74.6268C49.8317 74.34 50.4809 74.2861 51.0783 74.477C51.6757 74.6679 52.1729 75.0886 52.46 75.6456ZM65.9489 68.7105C66.1089 69.0213 66.1978 69.3638 66.2092 69.7133C66.2205 70.0628 66.1541 70.4106 66.0146 70.7316C65.8751 71.0525 65.666 71.3387 65.4025 71.5693C65.139 71.7999 64.8276 71.9692 64.4908 72.0651C64.1544 72.1614 63.8009 72.1819 63.4558 72.1254C63.1107 72.0689 62.7825 71.9366 62.4949 71.7382C62.2073 71.5397 61.9673 71.2799 61.7924 70.9776C61.6174 70.6753 61.5117 70.3379 61.4829 69.9897C61.4509 69.602 61.5152 69.2122 61.6701 68.855C61.825 68.4979 62.0657 68.1842 62.3708 67.942C62.676 67.6998 63.0361 67.5365 63.4194 67.4666C63.8026 67.3967 64.197 67.4223 64.5677 67.5412C65.1657 67.7325 65.6624 68.1534 65.9489 68.7105ZM79.4339 61.7774C79.5939 62.0882 79.6828 62.4307 79.6942 62.7802C79.7056 63.1297 79.6391 63.4775 79.4996 63.7985C79.3601 64.1194 79.1511 64.4055 78.8875 64.6361C78.624 64.8668 78.3126 65.0361 77.9758 65.132C77.6394 65.2282 77.286 65.2488 76.9408 65.1923C76.5957 65.1358 76.2676 65.0035 75.9799 64.805C75.6923 64.6066 75.4524 64.3468 75.2774 64.0445C75.1024 63.7422 74.9968 63.4048 74.968 63.0565C74.9298 62.5904 75.031 62.1231 75.2587 61.7141C75.4865 61.305 75.8305 60.9725 76.2473 60.7586C76.8057 60.472 77.4548 60.4183 78.0521 60.6091C78.6494 60.8 79.1466 61.2206 79.4339 61.7774ZM92.9197 54.8439C93.0798 55.1547 93.1687 55.4972 93.18 55.8467C93.1914 56.1962 93.1249 56.544 92.9854 56.865C92.8459 57.1859 92.6369 57.472 92.3734 57.7026C92.1098 57.9333 91.7985 58.1026 91.4617 58.1985C91.1253 58.2946 90.7718 58.315 90.4268 58.2584C90.0817 58.2018 89.7536 58.0696 89.466 57.8711C89.1784 57.6727 88.9385 57.413 88.7635 57.1108C88.5885 56.8085 88.4827 56.4712 88.4538 56.123C88.4284 55.8135 88.4643 55.5019 88.5595 55.2061C88.6546 54.9102 88.8073 54.6359 89.0086 54.3989C89.2099 54.1619 89.4559 53.9668 89.7327 53.8247C90.0094 53.6827 90.3113 53.5965 90.6213 53.5711C91.0876 53.5324 91.5547 53.6326 91.9637 53.859C92.3727 54.0854 92.7056 54.4286 92.9197 54.8439ZM106.405 47.9096C106.619 48.3253 106.705 48.7952 106.651 49.2598C106.597 49.7245 106.406 50.1629 106.103 50.5195C105.8 50.8757 105.398 51.1345 104.948 51.2631C104.498 51.3917 104.02 51.3844 103.575 51.2421C103.129 51.0998 102.736 50.8289 102.445 50.4636C102.154 50.0982 101.978 49.6548 101.938 49.1892C101.907 48.8016 101.972 48.4122 102.127 48.0554C102.283 47.6986 102.523 47.3853 102.829 47.1433C103.134 46.9013 103.493 46.738 103.876 46.6679C104.259 46.5977 104.654 46.6228 105.024 46.741C105.621 46.932 106.119 47.3525 106.405 47.9096ZM119.891 40.9772C120.105 41.3929 120.19 41.8628 120.136 42.3275C120.083 42.7921 119.892 43.2306 119.588 43.5871C119.285 43.9435 118.883 44.2024 118.433 44.3311C117.983 44.4598 117.505 44.4525 117.06 44.3101C116.615 44.1678 116.222 43.8967 115.931 43.5312C115.639 43.1657 115.463 42.7221 115.425 42.2564C115.393 41.8689 115.458 41.4795 115.613 41.1226C115.768 40.7658 116.009 40.4525 116.314 40.2104C116.619 39.9683 116.979 39.805 117.362 39.7348C117.745 39.6646 118.139 39.6897 118.509 39.8079C119.107 39.9992 119.604 40.4202 119.891 40.9772ZM18.9128 76.7211C19.0728 77.0319 19.1617 77.3744 19.1731 77.724C19.1845 78.0735 19.118 78.4213 18.9785 78.7422C18.839 79.0632 18.63 79.3493 18.3664 79.5799C18.1029 79.8105 17.7915 79.9799 17.4547 80.0757C17.1183 80.1718 16.7649 80.1923 16.4198 80.1357C16.0748 80.0791 15.7467 79.9468 15.4591 79.7484C15.1715 79.5499 14.9316 79.2903 14.7566 78.988C14.5816 78.6858 14.4758 78.3484 14.4469 78.0003C14.415 77.6126 14.4794 77.2229 14.6344 76.8658C14.7893 76.5087 15.0301 76.1951 15.3352 75.953C15.6404 75.7109 16.0006 75.5476 16.3838 75.4778C16.767 75.4079 17.1614 75.4336 17.532 75.5525C17.8279 75.6469 18.1022 75.7987 18.3391 75.9993C18.576 76.1998 18.771 76.4451 18.9128 76.7211ZM32.3986 69.7876C32.5585 70.0984 32.6473 70.4409 32.6585 70.7904C32.6698 71.1399 32.6033 71.4876 32.4639 71.8085C32.3244 72.1294 32.1154 72.4155 31.852 72.6461C31.5886 72.8768 31.2773 73.0462 30.9406 73.1422C30.6041 73.2384 30.2506 73.259 29.9055 73.2025C29.5604 73.146 29.2322 73.0138 28.9445 72.8154C28.6569 72.6169 28.4169 72.3573 28.2418 72.055C28.0667 71.7527 27.9609 71.4154 27.9319 71.0672C27.8938 70.601 27.9951 70.1338 28.2228 69.7248C28.4505 69.3157 28.7945 68.9832 29.2113 68.7692C29.7698 68.4823 30.4192 68.4284 31.0168 68.6194C31.6144 68.8103 32.1114 69.2305 32.3986 69.7876ZM45.8837 62.8545C46.0437 63.1653 46.1326 63.5078 46.144 63.8573C46.1553 64.2068 46.0889 64.5546 45.9494 64.8756C45.8099 65.1965 45.6008 65.4826 45.3373 65.7133C45.0738 65.9439 44.7624 66.1132 44.4256 66.2091C44.0892 66.3052 43.7358 66.3257 43.3907 66.2691C43.0457 66.2124 42.7175 66.0802 42.43 65.8817C42.1424 65.6833 41.9025 65.4236 41.7274 65.1214C41.5524 64.8191 41.4467 64.4818 41.4177 64.1337C41.3859 63.746 41.4502 63.3563 41.6052 62.9992C41.7602 62.642 42.0009 62.3285 42.3061 62.0864C42.6113 61.8443 42.9714 61.681 43.3546 61.6112C43.7378 61.5413 44.1322 61.567 44.5029 61.6859C44.7988 61.7803 45.073 61.9321 45.31 62.1326C45.5469 62.3332 45.7419 62.5785 45.8837 62.8545ZM59.3725 55.9194C59.5326 56.2302 59.6215 56.5727 59.6328 56.9222C59.6442 57.2718 59.5777 57.6196 59.4382 57.9405C59.2987 58.2615 59.0897 58.5476 58.8262 58.7782C58.5627 59.0088 58.2513 59.1782 57.9145 59.274C57.5781 59.3703 57.2246 59.3909 56.8795 59.3343C56.5343 59.2778 56.2062 59.1455 55.9186 58.9471C55.6309 58.7486 55.391 58.4889 55.216 58.1865C55.0411 57.8842 54.9354 57.5468 54.9066 57.1986C54.8622 56.6535 55.0084 56.1095 55.3202 55.6595C55.632 55.2094 56.0902 54.881 56.6167 54.7302C57.1433 54.5794 57.7056 54.6155 58.208 54.8324C58.7103 55.0494 59.1223 55.4332 59.3725 55.9194ZM72.8576 48.9863C73.0176 49.2971 73.1065 49.6396 73.1179 49.9891C73.1292 50.3386 73.0628 50.6864 72.9233 51.0074C72.7838 51.3283 72.5747 51.6145 72.3112 51.8451C72.0477 52.0757 71.7363 52.245 71.3995 52.3409C71.0631 52.4372 70.7096 52.4577 70.3645 52.4012C70.0194 52.3447 69.6912 52.2124 69.4036 52.0139C69.116 51.8155 68.8761 51.5557 68.7011 51.2534C68.5261 50.9511 68.4204 50.6137 68.3917 50.2655C68.3598 49.8778 68.4242 49.4881 68.5791 49.131C68.7341 48.7738 68.9748 48.4603 69.28 48.2182C69.5852 47.9761 69.9453 47.8128 70.3285 47.743C70.7118 47.6731 71.1062 47.6988 71.4768 47.8177C71.7727 47.9121 72.0469 48.0639 72.2839 48.2644C72.5208 48.465 72.7158 48.7103 72.8576 48.9863ZM86.3434 42.0528C86.5034 42.3636 86.5923 42.7061 86.6037 43.0556C86.6151 43.4051 86.5486 43.7529 86.4091 44.0739C86.2696 44.3948 86.0605 44.6809 85.797 44.9116C85.5335 45.1422 85.2221 45.3115 84.8853 45.4074C84.5489 45.5035 84.1955 45.524 83.8504 45.4674C83.5054 45.4107 83.1773 45.2785 82.8897 45.08C82.6021 44.8816 82.3622 44.6219 82.1872 44.3197C82.0122 44.0174 81.9064 43.6801 81.8775 43.3319C81.8521 43.0224 81.8881 42.7109 81.9834 42.4151C82.0786 42.1193 82.2312 41.8451 82.4325 41.6081C82.6338 41.3711 82.8798 41.176 83.1565 41.0339C83.4331 40.8918 83.7351 40.8055 84.0449 40.78C84.5114 40.7413 84.9787 40.8416 85.3878 41.0681C85.7968 41.2947 86.1294 41.6373 86.3434 42.0528ZM99.8292 35.1193C100.043 35.5349 100.129 36.0049 100.075 36.4695C100.021 36.9341 99.8303 37.3726 99.527 37.7292C99.3002 37.9957 99.0173 38.2089 98.6985 38.3534C98.3796 38.4978 98.0328 38.5701 97.683 38.5648C97.3331 38.5596 96.9889 38.477 96.675 38.323C96.3611 38.169 96.0853 37.9475 95.8675 37.6742C95.6496 37.4009 95.4953 37.0824 95.4158 36.742C95.3362 36.4016 95.3334 36.0476 95.4076 35.7057C95.4817 35.3639 95.631 35.0426 95.8445 34.7652C96.058 34.4878 96.3305 34.2612 96.6422 34.1017C97.2007 33.8151 97.8498 33.7612 98.4473 33.952C99.0447 34.1428 99.5417 34.5625 99.8292 35.1193ZM113.314 28.1862C113.528 28.6018 113.614 29.0717 113.56 29.5364C113.506 30.0011 113.315 30.4395 113.012 30.796C112.709 31.1525 112.307 31.4113 111.857 31.54C111.407 31.6687 110.929 31.6614 110.484 31.519C110.038 31.3767 109.645 31.1056 109.354 30.7401C109.063 30.3746 108.887 29.931 108.848 29.4653C108.817 29.0779 108.882 28.6886 109.038 28.3319C109.193 27.9753 109.433 27.6621 109.738 27.4202C110.043 27.1783 110.403 27.015 110.786 26.9448C111.169 26.8745 111.563 26.8996 111.933 27.0176C112.229 27.112 112.504 27.2638 112.741 27.4643C112.978 27.6648 113.172 27.9101 113.314 28.1862ZM12.4302 64.1124C12.5904 64.4232 12.6795 64.7658 12.6909 65.1154C12.7024 65.465 12.636 65.8128 12.4965 66.1339C12.357 66.4549 12.148 66.7411 11.8844 66.9718C11.6209 67.2025 11.3094 67.3719 10.9726 67.4678C10.6361 67.5638 10.2826 67.5842 9.93751 67.5275C9.59241 67.4708 9.26428 67.3385 8.97668 67.14C8.68908 66.9415 8.44914 66.6817 8.2741 66.3794C8.09906 66.0771 7.99327 65.7398 7.96432 65.3916C7.93243 65.0039 7.99683 64.6142 8.15179 64.2571C8.30676 63.9 8.5475 63.5864 8.85267 63.3443C9.15784 63.1022 9.518 62.9389 9.90121 62.8691C10.2844 62.7992 10.6788 62.8249 11.0494 62.9438C11.6475 63.1352 12.1438 63.5553 12.4302 64.1124ZM25.916 57.1789C26.0761 57.4897 26.165 57.8323 26.1764 58.1818C26.1877 58.5314 26.1213 58.8792 25.9819 59.2002C25.8424 59.5212 25.6334 59.8073 25.37 60.0381C25.1065 60.2688 24.7952 60.4383 24.4584 60.5343C24.1219 60.6304 23.7683 60.6509 23.4232 60.5943C23.078 60.5377 22.7498 60.4054 22.4621 60.207C22.1744 60.0085 21.9344 59.7488 21.7593 59.4464C21.5842 59.1441 21.4783 58.8067 21.4494 58.4585C21.4112 57.9923 21.5123 57.525 21.7401 57.116C21.9678 56.7069 22.3119 56.3744 22.7287 56.1605C23.2873 55.8736 23.9366 55.8197 24.5342 56.0106C25.1319 56.2016 25.6288 56.6218 25.916 57.1789ZM39.4011 50.2458C39.6149 50.6614 39.7004 51.1311 39.6468 51.5957C39.5931 52.0602 39.4027 52.4986 39.0996 52.8553C38.873 53.122 38.5901 53.3353 38.2713 53.4799C37.9525 53.6245 37.6056 53.6969 37.2557 53.6917C36.9058 53.6866 36.5615 53.6041 36.2475 53.4502C35.9335 53.2963 35.6577 53.0747 35.4398 52.8015C35.222 52.528 35.0678 52.2094 34.9883 51.8689C34.9089 51.5284 34.9062 51.1744 34.9803 50.8325C35.0545 50.4905 35.2037 50.1692 35.4172 49.8917C35.6307 49.6142 35.9032 49.3874 36.2149 49.2278C36.7733 48.941 37.4224 48.8871 38.0198 49.078C38.6172 49.2688 39.114 49.6889 39.4011 50.2458ZM52.89 43.3107C53.1038 43.7264 53.1892 44.1963 53.1354 44.6609C53.0816 45.1255 52.891 45.5639 52.5877 45.9206C52.361 46.1871 52.0782 46.4003 51.7594 46.5448C51.4407 46.6893 51.0939 46.7615 50.7441 46.7564C50.3943 46.7512 50.0501 46.6687 49.7362 46.5148C49.4223 46.361 49.1465 46.1395 48.9286 45.8664C48.7111 45.5929 48.557 45.2744 48.4776 44.934C48.3983 44.5936 48.3955 44.2397 48.4696 43.8979C48.5437 43.5561 48.6927 43.2348 48.906 42.9573C49.1193 42.6798 49.3915 42.4529 49.703 42.2931C50.2614 42.006 50.9107 41.9519 51.5083 42.1427C52.1058 42.3336 52.6028 42.7536 52.89 43.3107ZM66.375 36.3776C66.5889 36.7932 66.6744 37.2629 66.6207 37.7275C66.567 38.192 66.3766 38.6304 66.0735 38.9871C65.8469 39.2538 65.564 39.4671 65.2452 39.6117C64.9264 39.7563 64.5796 39.8287 64.2296 39.8235C63.8797 39.8184 63.5354 39.7359 63.2215 39.582C62.9075 39.4281 62.6316 39.2065 62.4137 38.9333C62.1226 38.5675 61.947 38.1233 61.909 37.6573C61.871 37.1912 61.9725 36.7242 62.2005 36.3154C62.4092 35.9413 62.7155 35.6306 63.0867 35.4164C63.4579 35.2021 63.8802 35.0924 64.3086 35.0989C64.737 35.1053 65.1555 35.2277 65.5194 35.453C65.8834 35.6784 66.1788 35.9974 66.375 36.3776ZM79.8608 29.4441C80.0747 29.8598 80.1601 30.3297 80.1063 30.7943C80.0525 31.2589 79.8619 31.6973 79.5586 32.054C79.3319 32.3205 79.049 32.5337 78.7303 32.6782C78.4115 32.8227 78.0648 32.8949 77.715 32.8897C77.3652 32.8846 77.021 32.8021 76.7071 32.6482C76.3932 32.4943 76.1174 32.2729 75.8995 31.9998C75.6817 31.7263 75.5275 31.4077 75.4481 31.0672C75.3686 30.7267 75.3659 30.3727 75.44 30.0308C75.5142 29.6888 75.6634 29.3675 75.8769 29.09C76.0904 28.8125 76.3629 28.5857 76.6746 28.4261C77.233 28.1395 77.8821 28.0857 78.4794 28.2766C79.0767 28.4674 79.5736 28.8873 79.8608 29.4441ZM93.3466 22.5106C93.5606 22.9262 93.6461 23.3962 93.5923 23.8608C93.5385 24.3254 93.3478 24.7638 93.0444 25.1205C92.8177 25.387 92.5348 25.6001 92.2161 25.7446C91.8973 25.8892 91.5506 25.9614 91.2008 25.9562C90.851 25.9511 90.5068 25.8686 90.1929 25.7147C89.879 25.5608 89.6032 25.3394 89.3853 25.0663C89.1673 24.7929 89.0128 24.4745 88.9332 24.134C88.8536 23.7935 88.8507 23.4394 88.9248 23.0975C88.9989 22.7555 89.1481 22.4342 89.3617 22.1567C89.5753 21.8792 89.8478 21.6525 90.1597 21.493C90.7182 21.2063 91.3673 21.1525 91.9647 21.3433C92.5621 21.5341 93.0591 21.9538 93.3466 22.5106ZM106.832 15.5775C107.046 15.9931 107.131 16.463 107.077 16.9277C107.024 17.3924 106.833 17.8308 106.529 18.1873C106.303 18.454 106.02 18.6673 105.701 18.8119C105.382 18.9565 105.036 19.0288 104.686 19.0236C104.336 19.0184 103.992 18.9359 103.678 18.7819C103.364 18.628 103.088 18.4064 102.87 18.1332C102.579 17.7673 102.404 17.3232 102.366 16.8571C102.328 16.3911 102.429 15.924 102.657 15.5153C102.866 15.1412 103.172 14.8305 103.543 14.6162C103.915 14.402 104.337 14.2923 104.765 14.2987C105.194 14.3052 105.612 14.4276 105.976 14.6529C106.34 14.8782 106.635 15.1972 106.832 15.5775ZM5.90138 51.4137C6.06142 51.7245 6.15033 52.067 6.16169 52.4165C6.17305 52.766 6.10659 53.1138 5.96709 53.4348C5.82759 53.7557 5.61854 54.0418 5.35503 54.2724C5.09152 54.503 4.78013 54.6724 4.44333 54.7683C4.10691 54.8644 3.75348 54.8848 3.40843 54.8282C3.06338 54.7716 2.73527 54.6393 2.44769 54.4409C2.16011 54.2425 1.92019 53.9828 1.74517 53.6806C1.57015 53.3783 1.46438 53.041 1.43547 52.6928C1.40358 52.3051 1.46797 51.9155 1.62294 51.5583C1.77791 51.2012 2.01865 50.8877 2.32382 50.6455C2.62899 50.4034 2.98915 50.2402 3.37236 50.1703C3.75556 50.1005 4.14997 50.1262 4.52059 50.2451C4.81649 50.3395 5.09076 50.4913 5.3277 50.6918C5.56463 50.8923 5.75958 51.1376 5.90138 51.4137ZM19.3872 44.4802C19.5471 44.791 19.6359 45.1335 19.6471 45.4829C19.6584 45.8324 19.5919 46.1801 19.4524 46.501C19.313 46.822 19.104 47.108 18.8406 47.3387C18.5771 47.5693 18.2658 47.7388 17.9291 47.8348C17.5927 47.931 17.2392 47.9516 16.8941 47.895C16.549 47.8385 16.2208 47.7063 15.9331 47.5079C15.6455 47.3095 15.4055 47.0498 15.2304 46.7475C15.0553 46.4453 14.9495 46.1079 14.9205 45.7597C14.8951 45.4502 14.931 45.1386 15.0262 44.8427C15.1214 44.5469 15.274 44.2726 15.4753 44.0356C15.6766 43.7986 15.9226 43.6035 16.1994 43.4614C16.4761 43.3194 16.7781 43.2332 17.088 43.2078C17.5545 43.1689 18.0219 43.269 18.4312 43.4955C18.8404 43.722 19.1731 44.0646 19.3872 44.4802ZM32.8722 37.547C33.0323 37.8578 33.1212 38.2004 33.1326 38.5499C33.1439 38.8994 33.0774 39.2472 32.9379 39.5681C32.7984 39.8891 32.5894 40.1752 32.3259 40.4058C32.0624 40.6364 31.751 40.8058 31.4142 40.9017C31.0778 40.9977 30.7243 41.0182 30.3793 40.9616C30.0342 40.905 29.7061 40.7727 29.4186 40.5743C29.131 40.3758 28.891 40.1162 28.716 39.8139C28.541 39.5117 28.4352 39.1744 28.4063 38.8262C28.3744 38.4385 28.4388 38.0488 28.5938 37.6917C28.7488 37.3346 28.9895 37.021 29.2947 36.7789C29.5999 36.5368 29.96 36.3736 30.3432 36.3037C30.7264 36.2339 31.1208 36.2595 31.4914 36.3785C31.7873 36.4729 32.0616 36.6247 32.2986 36.8252C32.5355 37.0257 32.7304 37.271 32.8722 37.547ZM46.3611 30.612C46.5212 30.9228 46.6101 31.2653 46.6214 31.6148C46.6328 31.9643 46.5663 32.3121 46.4268 32.633C46.2873 32.954 46.0783 33.2401 45.8148 33.4707C45.5513 33.7013 45.2399 33.8707 44.9031 33.9666C44.5666 34.0627 44.2132 34.0831 43.8682 34.0265C43.5231 33.9699 43.195 33.8376 42.9074 33.6392C42.6198 33.4408 42.3799 33.1811 42.2049 32.8788C42.0299 32.5766 41.9241 32.2393 41.8952 31.8911C41.8508 31.346 41.9969 30.8021 42.3088 30.352C42.6206 29.9019 43.0788 29.5735 43.6053 29.4227C44.1319 29.2719 44.6942 29.3081 45.1965 29.525C45.6989 29.7419 46.1109 30.1258 46.3611 30.612ZM59.8462 23.6788C60.0062 23.9896 60.0951 24.3322 60.1065 24.6817C60.1178 25.0312 60.0514 25.379 59.9119 25.6999C59.7724 26.0209 59.5633 26.307 59.2998 26.5376C59.0363 26.7682 58.7249 26.9376 58.3881 27.0335C58.0517 27.1295 57.6983 27.15 57.3532 27.0934C57.0082 27.0368 56.6801 26.9045 56.3925 26.7061C56.1049 26.5077 55.865 26.248 55.69 25.9457C55.5149 25.6435 55.4092 25.3062 55.3802 24.958C55.3422 24.4918 55.4434 24.0247 55.6711 23.6156C55.8989 23.2065 56.2429 22.874 56.6596 22.6601C57.2181 22.3734 57.8673 22.3197 58.4648 22.5107C59.0622 22.7017 59.559 23.1218 59.8462 23.6788ZM73.332 16.7453C73.492 17.0561 73.5809 17.3987 73.5923 17.7482C73.6036 18.0977 73.5372 18.4455 73.3977 18.7664C73.2582 19.0874 73.0491 19.3735 72.7856 19.6041C72.5221 19.8347 72.2107 20.0041 71.8739 20.1C71.5375 20.196 71.1841 20.2165 70.839 20.1599C70.494 20.1033 70.1659 19.971 69.8783 19.7726C69.5907 19.5741 69.3508 19.3145 69.1758 19.0122C69.0007 18.71 68.895 18.3726 68.8661 18.0245C68.8279 17.5583 68.929 17.0911 69.1568 16.682C69.3845 16.2729 69.7286 15.9404 70.1454 15.7266C70.7039 15.4397 71.3532 15.3858 71.9507 15.5769C72.5482 15.7679 73.045 16.1882 73.332 16.7453ZM86.8178 9.81182C87.0317 10.2275 87.1172 10.6974 87.0634 11.162C87.0096 11.6267 86.8189 12.0651 86.5155 12.4217C86.2888 12.6883 86.0059 12.9014 85.687 13.0459C85.3682 13.1904 85.0214 13.2626 84.6716 13.2573C84.3217 13.2521 83.9775 13.1695 83.6636 13.0155C83.3497 12.8616 83.0739 12.64 82.8561 12.3668C82.638 12.0934 82.4836 11.775 82.404 11.4345C82.3243 11.094 82.3214 10.7399 82.3955 10.398C82.4697 10.056 82.6189 9.73464 82.8325 9.45715C83.046 9.17965 83.3186 8.95296 83.6304 8.79345C84.189 8.50677 84.8383 8.45298 85.4359 8.6439C86.0334 8.83482 86.5304 9.25485 86.8178 9.81182ZM100.303 2.87871C100.517 3.29433 100.602 3.76429 100.549 4.22895C100.495 4.69361 100.304 5.13203 100.001 5.48858C99.6974 5.84501 99.2955 6.10389 98.8455 6.23256C98.3956 6.36123 97.9177 6.35393 97.4723 6.21157C97.0269 6.06921 96.6339 5.79818 96.3428 5.43268C96.0517 5.06717 95.8757 4.62358 95.8369 4.15787C95.8059 3.77042 95.8709 3.38117 96.0261 3.02449C96.1813 2.66781 96.4221 2.35467 96.727 2.11274C97.0319 1.8708 97.3917 1.70752 97.7745 1.6373C98.1573 1.56708 98.5515 1.5921 98.922 1.71013C99.2179 1.80453 99.4922 1.95634 99.7292 2.15686C99.9661 2.35738 100.161 2.60268 100.303 2.87871Z"
                                    fill="currentColor"
                                />
                            </g>
                        </svg>
                    </div>
                </div>
                <div className="col-lg-6">
                    <div className="cs_section_heading cs_style_1">
                        {section_subtitle && (
                            <p
                                className="cs_section_subtitle cs_fs_18 cs_medium"
                                dangerouslySetInnerHTML={{
                                    __html: section_subtitle
                                }}
                            />
                        )}

                        {section_title && (
                            <>
                                <h2
                                    className="cs_section_title cs_fs_53 cs_normal mb-0"
                                    dangerouslySetInnerHTML={{
                                        __html: section_title
                                    }}
                                />
                                <div className="cs_height_20 cs_height_lg_20" />
                            </>
                        )}

                        {section_description && (
                            <>
                                <p
                                    className="mb-0"
                                    dangerouslySetInnerHTML={{
                                        __html: section_description
                                    }}
                                />
                                <div className="cs_height_30 cs_height_lg_30" />
                            </>
                        )}
                    </div>
                    <ul className="cs_list cs_style_1 cs_mp0">
                        {feature_list?.map((item, index) => (
                            <li key={index}>
                                {(item.feature_title || item.feature_subtitle) && (
                                    <i className="cs_tick_icon cs_accent_color d-flex">
                                        <svg width={18} height={17} viewBox="0 0 18 17" fill="none" xmlns="http://www.w3.org/2000/svg">
                                            <path
                                                d="M0 9.62275C0.0320847 8.83012 0.390363 8.2499 1.11227 7.93388C1.84487 7.61269 2.54004 7.73702 3.1443 8.25508C4.06406 9.0477 4.96777 9.85587 5.87684 10.6589C6.04796 10.8091 6.21908 10.9645 6.39554 11.1148C6.65757 11.3427 6.88751 11.3323 7.12279 11.0733C9.096 8.91819 11.0639 6.75789 13.0371 4.5976C14.3686 3.13668 15.7054 1.68094 17.037 0.220014C17.2027 0.0386945 17.3952 -0.0493752 17.6412 0.0283334C17.8498 0.0956808 18.0102 0.277001 17.9995 0.494585C17.9941 0.608557 17.946 0.732891 17.8819 0.831322C16.3685 3.19884 14.8552 5.56118 13.3419 7.92352C11.5986 10.6433 9.85534 13.3631 8.11207 16.0881C7.80727 16.5647 7.39551 16.8859 6.81264 16.974C6.15491 17.0776 5.60947 16.8704 5.19237 16.3782C3.69508 14.6116 2.20849 12.8399 0.716557 11.0681C0.433143 10.7469 0.133686 10.4257 0.0534744 9.98539C0.0267372 9.85587 0.0160423 9.73154 0 9.62275Z"
                                                fill="currentColor"
                                            />
                                        </svg>
                                    </i>
                                )}

                                {item.feature_title && (
                                    <h3
                                        className="cs_fs_24 cs_normal mb-0"
                                        dangerouslySetInnerHTML={{
                                            __html: item.feature_title
                                        }}
                                    />
                                )}
                                {item.feature_subtitle && (
                                    <p
                                        dangerouslySetInnerHTML={{
                                            __html: item.feature_subtitle
                                        }}
                                    />
                                )}
                            </li>
                        ))}
                    </ul>
                </div>
            </div>
        </div>
    )
}
